/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;

public class RootLoggerModelHandler
extends ModelHandlerBase {
    Logger root;
    boolean inError = false;

    /*
     * WARNING - void declaration
     */
    public RootLoggerModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static RootLoggerModelHandler makeInstance(Context context, ModelInterpretationContext ic) {
        Context context2;
        return new RootLoggerModelHandler(context2);
    }

    protected Class<RootLoggerModel> getSupportedModelClass() {
        return RootLoggerModel.class;
    }

    /*
     * WARNING - void declaration
     */
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        void var1_1;
        void var3_3;
        this.inError = false;
        RootLoggerModel rootLoggerModel = (RootLoggerModel)model;
        LoggerContext loggerContext = (LoggerContext)this.context;
        this.root = var3_3.getLogger("ROOT");
        String levelStr = mic.subst(rootLoggerModel.getLevel());
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)levelStr)) {
            void var2_2;
            Level level = Level.toLevel(levelStr);
            this.addInfo("Setting level of ROOT logger to " + String.valueOf(level));
            this.root.setLevel((Level)var2_2);
        }
        var1_1.pushObject((Object)this.root);
    }

    /*
     * WARNING - void declaration
     */
    public void postHandle(ModelInterpretationContext mic, Model model) {
        void var1_1;
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.root) {
            void var2_2;
            this.addWarn("The object [" + String.valueOf(var2_2) + "] on the top the of the stack is not the root logger");
            return;
        }
        var1_1.popObject();
    }
}

