/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.JoranConstants;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.model.util.VariableSubstitutionsHelper;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class PropertiesConfigurator
extends ContextAwareBase {
    static Comparator<String> LENGTH_COMPARATOR = new Comparator<String>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(String o1, String o2) {
            void var1_1;
            void var2_2;
            int len1;
            int n = o2 == null ? 0 : o2.length();
            int diff = n - (len1 = o1 == null ? 0 : o1.length());
            if (diff != 0) {
                void var3_3;
                return (int)var3_3;
            }
            return var2_2.compareTo((String)var1_1);
        }
    };
    static final String LOGBACK_PREFIX = "logback";
    static final String LOGBACK_ROOT_LOGGER_PREFIX = "logback.root";
    static final int LOGBACK_ROOT_LOGGER_PREFIX_LENGTH = 12;
    public static final String LOGBACK_LOGGER_PREFIX = "logback.logger.";
    static final int LOGBACK_LOGGER_PREFIX_LENGTH = 15;
    VariableSubstitutionsHelper variableSubstitutionsHelper;

    LoggerContext getLoggerContext() {
        return (LoggerContext)this.getContext();
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(Context context) {
        void var1_1;
        super.setContext((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void doConfigure(URL url) throws JoranException {
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            InputStream in = urlConnection.getInputStream();
            this.doConfigure(in);
            return;
        }
        catch (IOException ioe) {
            void var2_3;
            void var3_5;
            void var1_1;
            String errMsg = "Could not open URL [" + String.valueOf(var1_1) + "].";
            this.addError(errMsg, ioe);
            throw new JoranException((String)var3_5, (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doConfigure(File file) throws JoranException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.doConfigure(fileInputStream);
        }
        catch (IOException e) {
            void var2_4;
            void var1_1;
            throw new JoranException("Failed to load file " + String.valueOf(var1_1), (Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doConfigure(String filename) throws JoranException {
        void var1_1;
        this.doConfigure(new File((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void doConfigure(InputStream inputStream) throws JoranException {
        void var2_2;
        Properties props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            try {
                void var2_3;
                throw new JoranException("Failed to load from input stream", (Throwable)var2_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                this.close((InputStream)var1_1);
                throw throwable;
            }
        }
        this.close(inputStream);
        this.doConfigure((Properties)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void close(InputStream inputStream) throws JoranException {
        if (inputStream != null) {
            try {
                inputStream.close();
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new JoranException("failed to close stream", (Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void doConfigure(Properties properties) {
        void var1_1;
        void var2_2;
        Map<String, String> variablesMap = this.extractVariablesMap(properties);
        Map<String, String> instructionMap = this.extractLogbackInstructionMap(properties);
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(this.context, (Map)var2_2);
        this.configureLoggers(instructionMap);
        this.configureRootLogger((Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void configureRootLogger(Map<String, String> instructionMap) {
        String val = this.subst(instructionMap.get(LOGBACK_ROOT_LOGGER_PREFIX));
        if (val != null) {
            void var1_1;
            this.setLevel("ROOT", (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void configureLoggers(Map<String, String> instructionMap) {
        for (String key : instructionMap.keySet()) {
            void var3_3;
            if (!key.startsWith(LOGBACK_LOGGER_PREFIX)) continue;
            String loggerName = key.substring(LOGBACK_LOGGER_PREFIX_LENGTH);
            String value = this.subst(instructionMap.get(key));
            this.setLevel(loggerName, (String)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setLevel(String loggerName, String levelStr) {
        void var1_1;
        void var3_3;
        void var2_2;
        Logger logger = this.getLoggerContext().getLogger(loggerName);
        if ("INHERITED".equalsIgnoreCase(levelStr) || JoranConstants.NULL.equalsIgnoreCase(levelStr)) {
            if ("ROOT".equalsIgnoreCase(loggerName)) {
                this.addError("The level for the ROOT logger cannot be set to NULL or INHERITED. Ignoring.");
                return;
            }
            this.addInfo("Setting level of logger [" + loggerName + "] to null, i.e. INHERITED");
            logger.setLevel(null);
            return;
        }
        Level level = Level.toLevel((String)var2_2);
        var3_3.setLevel((Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> extractVariablesMap(Properties properties) {
        void var2_2;
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            if (key == null || key.startsWith(LOGBACK_PREFIX)) continue;
            variablesMap.put(key, properties.getProperty(key));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> extractLogbackInstructionMap(Properties properties) {
        void var2_2;
        TreeMap<String, String> instructionMap = new TreeMap<String, String>(LENGTH_COMPARATOR);
        for (String key : properties.stringPropertyNames()) {
            if (key == null || !key.startsWith(LOGBACK_PREFIX)) continue;
            instructionMap.put(key, properties.getProperty(key));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String subst(String ref) {
        void var2_2;
        String substituted = this.variableSubstitutionsHelper.subst(ref);
        if (ref != null && !ref.equals(substituted)) {
            void var1_1;
            this.addInfo("value \"" + substituted + "\" substituted for \"" + (String)var1_1 + "\"");
        }
        return var2_2;
    }
}

