/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggerComparator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.TurboFilterList;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.classic.util.LoggerNameUtil;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.SequenceNumberGenerator;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.ILoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.MDCAdapter;

public class LoggerContext
extends ContextBase
implements LifeCycle,
ILoggerFactory {
    public static final boolean DEFAULT_PACKAGING_DATA = false;
    final Logger root;
    private int size;
    private int noAppenderWarning = 0;
    private final List<LoggerContextListener> loggerContextListenerList = new ArrayList<LoggerContextListener>();
    private Map<String, Logger> loggerCache;
    private LoggerContextVO loggerContextRemoteView;
    private final TurboFilterList turboFilterList = new TurboFilterList();
    private boolean packagingDataEnabled = false;
    SequenceNumberGenerator sequenceNumberGenerator = null;
    MDCAdapter mdcAdapter;
    private int maxCallerDataDepth = 8;
    int resetCount = 0;
    private List<String> frameworkPackages;

    public LoggerContext() {
        this.loggerCache = new ConcurrentHashMap<String, Logger>();
        this.loggerContextRemoteView = new LoggerContextVO(this);
        this.root = new Logger("ROOT", null, this);
        this.root.setLevel(Level.DEBUG);
        this.loggerCache.put("ROOT", this.root);
        this.initEvaluatorMap();
        this.size = 1;
        this.frameworkPackages = new ArrayList<String>();
        this.start();
    }

    void initEvaluatorMap() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    private void updateLoggerContextVO() {
        this.loggerContextRemoteView = new LoggerContextVO(this);
    }

    /*
     * WARNING - void declaration
     */
    public void putProperty(String key, String val) {
        void var2_2;
        void var1_1;
        super.putProperty((String)var1_1, (String)var2_2);
        this.updateLoggerContextVO();
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        super.setName((String)var1_1);
        this.updateLoggerContextVO();
    }

    /*
     * WARNING - void declaration
     */
    public final Logger getLogger(Class<?> clazz) {
        void var1_1;
        return this.getLogger(var1_1.getName());
    }

    public Logger getLogger(String name) {
        int h;
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if ("ROOT".equalsIgnoreCase(name)) {
            return this.root;
        }
        int i = 0;
        Logger logger = this.root;
        Logger childLogger = this.loggerCache.get(name);
        if (childLogger != null) {
            return childLogger;
        }
        do {
            String childName = (h = LoggerNameUtil.getSeparatorIndexOf(name, i)) == -1 ? name : name.substring(0, h);
            i = h + 1;
            Logger logger2 = logger;
            synchronized (logger2) {
                childLogger = logger.getChildByName(childName);
                if (childLogger == null) {
                    childLogger = logger.createChildByName(childName);
                    this.loggerCache.put(childName, childLogger);
                    this.incSize();
                }
            }
            logger = childLogger;
        } while (h != -1);
        return childLogger;
    }

    private void incSize() {
        ++this.size;
    }

    int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public Logger exists(String name) {
        void var1_1;
        return this.loggerCache.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void noAppenderDefinedWarning(Logger logger) {
        if (this.noAppenderWarning++ == 0) {
            void var1_1;
            this.getStatusManager().add((Status)new WarnStatus("No appenders present in context [" + this.getName() + "] for logger [" + logger.getName() + "].", (Object)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Logger> getLoggerList() {
        void var1_1;
        Collection<Logger> collection = this.loggerCache.values();
        ArrayList<Logger> loggerList = new ArrayList<Logger>(collection);
        Collections.sort(loggerList, new LoggerComparator());
        return var1_1;
    }

    public LoggerContextVO getLoggerContextRemoteView() {
        return this.loggerContextRemoteView;
    }

    /*
     * WARNING - void declaration
     */
    public void setPackagingDataEnabled(boolean packagingDataEnabled) {
        void var1_1;
        this.packagingDataEnabled = var1_1;
    }

    public boolean isPackagingDataEnabled() {
        return this.packagingDataEnabled;
    }

    void cancelScheduledTasks() {
        try {
            this.configurationLock.lock();
            for (ScheduledFuture scheduledFuture : this.scheduledFutures) {
                scheduledFuture.cancel(false);
            }
            this.scheduledFutures.clear();
            return;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resetStatusListenersExceptResetResistant() {
        StatusManager sm = this.getStatusManager();
        for (StatusListener sl : sm.getCopyOfStatusListenerList()) {
            void var3_3;
            if (sl.isResetResistant()) continue;
            sm.remove((StatusListener)var3_3);
        }
    }

    public TurboFilterList getTurboFilterList() {
        return this.turboFilterList;
    }

    /*
     * WARNING - void declaration
     */
    public void addTurboFilter(TurboFilter newFilter) {
        void var1_1;
        this.turboFilterList.add(var1_1);
    }

    public void resetTurboFilterList() {
        for (TurboFilter turboFilter : this.turboFilterList) {
            turboFilter.stop();
        }
        this.turboFilterList.clear();
    }

    /*
     * WARNING - void declaration
     */
    final FilterReply getTurboFilterChainDecision_0_3OrMore(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision((Marker)var1_1, (Logger)var2_2, (Level)var3_3, format, params, t);
    }

    /*
     * WARNING - void declaration
     */
    final FilterReply getTurboFilterChainDecision_1(Marker marker, Logger logger, Level level, String format, Object param, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision((Marker)var1_1, (Logger)var2_2, (Level)var3_3, format, new Object[]{param}, t);
    }

    /*
     * WARNING - void declaration
     */
    final FilterReply getTurboFilterChainDecision_2(Marker marker, Logger logger, Level level, String format, Object param1, Object param2, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision((Marker)var1_1, (Logger)var2_2, (Level)var3_3, format, new Object[]{param1, param2}, t);
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(LoggerContextListener listener) {
        void var1_1;
        this.loggerContextListenerList.add((LoggerContextListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeListener(LoggerContextListener listener) {
        void var1_1;
        this.loggerContextListenerList.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void resetListenersExceptResetResistant() {
        void var1_1;
        ArrayList<void> toRetain = new ArrayList<void>();
        for (LoggerContextListener lcl : this.loggerContextListenerList) {
            void var3_3;
            if (!lcl.isResetResistant()) continue;
            toRetain.add(var3_3);
        }
        this.loggerContextListenerList.retainAll((Collection<?>)var1_1);
    }

    private void resetAllListeners() {
        this.loggerContextListenerList.clear();
    }

    public List<LoggerContextListener> getCopyOfListenerList() {
        return new ArrayList<LoggerContextListener>(this.loggerContextListenerList);
    }

    void fireOnLevelChange(Logger logger, Level level) {
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            loggerContextListener.onLevelChange(logger, level);
        }
    }

    private void fireOnReset() {
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            loggerContextListener.onReset(this);
        }
    }

    private void fireOnStart() {
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            loggerContextListener.onStart(this);
        }
    }

    private void fireOnStop() {
        for (LoggerContextListener loggerContextListener : this.loggerContextListenerList) {
            loggerContextListener.onStop(this);
        }
    }

    public void start() {
        super.start();
        this.fireOnStart();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.configurationLock.lock();
            if (!this.isStarted()) {
                return;
            }
            this.reset();
            this.fireOnStop();
            this.resetAllListeners();
            super.stop();
            return;
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    public void reset() {
        ++this.resetCount;
        super.reset();
        this.initEvaluatorMap();
        this.initCollisionMaps();
        this.root.recursiveReset();
        this.resetTurboFilterList();
        this.cancelScheduledTasks();
        this.fireOnReset();
        this.resetListenersExceptResetResistant();
        this.resetStatusListenersExceptResetResistant();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[" + this.getName() + "]";
    }

    public int getMaxCallerDataDepth() {
        return this.maxCallerDataDepth;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxCallerDataDepth(int maxCallerDataDepth) {
        void var1_1;
        this.maxCallerDataDepth = var1_1;
    }

    public List<String> getFrameworkPackages() {
        return this.frameworkPackages;
    }

    /*
     * WARNING - void declaration
     */
    public void setSequenceNumberGenerator(SequenceNumberGenerator sng) {
        void var1_1;
        this.sequenceNumberGenerator = var1_1;
    }

    public SequenceNumberGenerator getSequenceNumberGenerator() {
        return this.sequenceNumberGenerator;
    }

    public MDCAdapter getMDCAdapter() {
        return this.mdcAdapter;
    }

    /*
     * WARNING - void declaration
     */
    public void setMDCAdapter(MDCAdapter anAdapter) {
        void var1_1;
        if (this.mdcAdapter != null) {
            StatusManager statusManager = this.getStatusManager();
            statusManager.add((Status)new WarnStatus("mdcAdapter being reset a second time", (Object)this));
        }
        this.mdcAdapter = var1_1;
    }
}

