/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LoggerNameUtil;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.DefaultLoggingEventBuilder;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventAware;
import org.slf4j.spi.LoggingEventBuilder;

public final class Logger
implements AppenderAttachable<ILoggingEvent>,
Serializable,
org.slf4j.Logger,
LocationAwareLogger,
LoggingEventAware {
    private static final long serialVersionUID = 5454405123156820674L;
    public static final String FQCN = Logger.class.getName();
    private String name;
    private transient Level level;
    private transient int effectiveLevelInt;
    private transient Logger parent;
    private transient List<Logger> childrenList;
    private transient AppenderAttachableImpl<ILoggingEvent> aai;
    private transient boolean additive = true;
    final transient LoggerContext loggerContext;

    /*
     * WARNING - void declaration
     */
    Logger(String name, Logger parent, LoggerContext loggerContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.parent = var2_2;
        this.loggerContext = var3_3;
    }

    public final Level getEffectiveLevel() {
        return Level.toLevel(this.effectiveLevelInt);
    }

    final int getEffectiveLevelInt() {
        return this.effectiveLevelInt;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final String getName() {
        return this.name;
    }

    private boolean isRootLogger() {
        return this.parent == null;
    }

    final Logger getChildByName(String childName) {
        if (this.childrenList == null) {
            return null;
        }
        int len = this.childrenList.size();
        for (int i = 0; i < len; ++i) {
            Logger childLogger_i = this.childrenList.get(i);
            String childName_i = childLogger_i.getName();
            if (!childName.equals(childName_i)) continue;
            return childLogger_i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void setLevel(Level newLevel) {
        void var1_1;
        if (this.level == newLevel) {
            return;
        }
        if (newLevel == null && this.isRootLogger()) {
            throw new IllegalArgumentException("The level of the root logger cannot be set to null");
        }
        this.level = newLevel;
        if (newLevel == null) {
            this.effectiveLevelInt = this.parent.effectiveLevelInt;
            newLevel = this.parent.getEffectiveLevel();
        } else {
            this.effectiveLevelInt = newLevel.levelInt;
        }
        if (this.childrenList != null) {
            int len = this.childrenList.size();
            for (int i = 0; i < len; ++i) {
                Logger logger = this.childrenList.get(i);
                logger.handleParentLevelChange(this.effectiveLevelInt);
            }
        }
        this.loggerContext.fireOnLevelChange(this, (Level)var1_1);
    }

    private synchronized void handleParentLevelChange(int newParentLevelInt) {
        if (this.level == null) {
            this.effectiveLevelInt = newParentLevelInt;
            if (this.childrenList != null) {
                int len = this.childrenList.size();
                for (int i = 0; i < len; ++i) {
                    Logger logger = this.childrenList.get(i);
                    logger.handleParentLevelChange(newParentLevelInt);
                }
            }
        }
    }

    public final void detachAndStopAllAppenders() {
        if (this.aai != null) {
            this.aai.detachAndStopAllAppenders();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean detachAppender(String name) {
        void var1_1;
        if (this.aai == null) {
            return false;
        }
        return this.aai.detachAppender((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addAppender(Appender<ILoggingEvent> newAppender) {
        void var1_1;
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        this.aai.addAppender((Appender)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAttached(Appender<ILoggingEvent> appender) {
        void var1_1;
        if (this.aai == null) {
            return false;
        }
        return this.aai.isAttached((Appender)var1_1);
    }

    public final Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        if (this.aai == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.aai.iteratorForAppenders();
    }

    /*
     * WARNING - void declaration
     */
    public final Appender<ILoggingEvent> getAppender(String name) {
        void var1_1;
        if (this.aai == null) {
            return null;
        }
        return this.aai.getAppender((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void callAppenders(ILoggingEvent event) {
        void var2_2;
        int writes = 0;
        Logger l = this;
        while (l != null) {
            writes += l.appendLoopOnAppenders(event);
            if (!l.additive) break;
            l = l.parent;
        }
        if (var2_2 == false) {
            this.loggerContext.noAppenderDefinedWarning(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int appendLoopOnAppenders(ILoggingEvent event) {
        if (this.aai != null) {
            void var1_1;
            return this.aai.appendLoopOnAppenders((Object)var1_1);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean detachAppender(Appender<ILoggingEvent> appender) {
        void var1_1;
        if (this.aai == null) {
            return false;
        }
        return this.aai.detachAppender((Appender)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final Logger createChildByLastNamePart(String lastPart) {
        void var1_1;
        Logger childLogger;
        int n = LoggerNameUtil.getFirstSeparatorIndexOf(lastPart);
        if (n != -1) {
            throw new IllegalArgumentException("Child name [" + lastPart + " passed as parameter, may not include [.]");
        }
        if (this.childrenList == null) {
            this.childrenList = new CopyOnWriteArrayList<Logger>();
        }
        if (this.isRootLogger()) {
            Logger logger = this;
            childLogger = new Logger(lastPart, logger, logger.loggerContext);
        } else {
            Logger logger = this;
            childLogger = new Logger(this.name + "." + (String)((Object)childLogger), logger, logger.loggerContext);
        }
        this.childrenList.add(childLogger);
        childLogger.effectiveLevelInt = this.effectiveLevelInt;
        return var1_1;
    }

    private void localLevelReset() {
        this.effectiveLevelInt = 10000;
        if (this.isRootLogger()) {
            this.level = Level.DEBUG;
            return;
        }
        this.level = null;
    }

    final void recursiveReset() {
        this.detachAndStopAllAppenders();
        this.localLevelReset();
        this.additive = true;
        if (this.childrenList == null) {
            return;
        }
        for (Logger logger : this.childrenList) {
            logger.recursiveReset();
        }
    }

    /*
     * WARNING - void declaration
     */
    final Logger createChildByName(String childName) {
        void var1_1;
        int n = LoggerNameUtil.getSeparatorIndexOf(childName, this.name.length() + 1);
        if (n != -1) {
            throw new IllegalArgumentException("For logger [" + this.name + "] child name [" + childName + " passed as parameter, may not include '.' after index" + (this.name.length() + 1));
        }
        if (this.childrenList == null) {
            this.childrenList = new CopyOnWriteArrayList<Logger>();
        }
        Logger logger = this;
        Logger childLogger = new Logger(childName, logger, logger.loggerContext);
        this.childrenList.add(childLogger);
        childLogger.effectiveLevelInt = this.effectiveLevelInt;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void filterAndLog_0_Or3Plus(String localFQCN, Marker marker, Level level, String msg, Object[] params, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterReply decision = this.loggerContext.getTurboFilterChainDecision_0_3OrMore(marker, this, level, msg, params, t);
        if (decision == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : decision == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend((String)var1_1, (Marker)var2_2, (Level)var3_3, msg, params, t);
    }

    /*
     * WARNING - void declaration
     */
    private void filterAndLog_1(String localFQCN, Marker marker, Level level, String msg, Object param, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterReply decision = this.loggerContext.getTurboFilterChainDecision_1(marker, this, level, msg, param, t);
        if (decision == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : decision == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend((String)var1_1, (Marker)var2_2, (Level)var3_3, msg, new Object[]{param}, t);
    }

    /*
     * WARNING - void declaration
     */
    private void filterAndLog_2(String localFQCN, Marker marker, Level level, String msg, Object param1, Object param2, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        FilterReply decision = this.loggerContext.getTurboFilterChainDecision_2(marker, this, level, msg, param1, param2, t);
        if (decision == FilterReply.NEUTRAL ? this.effectiveLevelInt > level.levelInt : decision == FilterReply.DENY) {
            return;
        }
        this.buildLoggingEventAndAppend((String)var1_1, (Marker)var2_2, (Level)var3_3, msg, new Object[]{param1, param2}, t);
    }

    /*
     * WARNING - void declaration
     */
    private void buildLoggingEventAndAppend(String localFQCN, Marker marker, Level level, String msg, Object[] params, Throwable t) {
        void var1_1;
        void var2_2;
        void var3_3;
        LoggingEvent le = new LoggingEvent(localFQCN, this, (Level)var3_3, msg, t, params);
        le.addMarker((Marker)var2_2);
        this.callAppenders((ILoggingEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.TRACE, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.TRACE, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(Marker marker, String msg, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.TRACE, (String)var2_2, null, (Throwable)var3_3);
    }

    public final boolean isDebugEnabled() {
        return this.isDebugEnabled(null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isDebugEnabled(Marker marker) {
        void var1_1;
        FilterReply decision = this.callTurboFilters(marker, Level.DEBUG);
        if (decision == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 10000;
        }
        if (decision == FilterReply.DENY) {
            return false;
        }
        if (decision == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.DEBUG, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.DEBUG, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(Marker marker, String msg, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.DEBUG, (String)var2_2, null, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.ERROR, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.ERROR, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(Marker marker, String msg, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.ERROR, (String)var2_2, null, (Throwable)var3_3);
    }

    public final boolean isInfoEnabled() {
        return this.isInfoEnabled(null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isInfoEnabled(Marker marker) {
        void var1_1;
        FilterReply decision = this.callTurboFilters(marker, Level.INFO);
        if (decision == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 20000;
        }
        if (decision == FilterReply.DENY) {
            return false;
        }
        if (decision == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void info(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void info(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.INFO, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void info(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.INFO, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void info(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void info(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void info(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void info(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void info(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void info(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void info(Marker marker, String msg, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.INFO, (String)var2_2, null, (Throwable)var3_3);
    }

    public final boolean isTraceEnabled() {
        return this.isTraceEnabled(null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isTraceEnabled(Marker marker) {
        void var1_1;
        FilterReply decision = this.callTurboFilters(marker, Level.TRACE);
        if (decision == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 5000;
        }
        if (decision == FilterReply.DENY) {
            return false;
        }
        if (decision == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(var1_1));
    }

    public final boolean isErrorEnabled() {
        return this.isErrorEnabled(null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isErrorEnabled(Marker marker) {
        void var1_1;
        FilterReply decision = this.callTurboFilters(marker, Level.ERROR);
        if (decision == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 40000;
        }
        if (decision == FilterReply.DENY) {
            return false;
        }
        if (decision == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(var1_1));
    }

    public final boolean isWarnEnabled() {
        return this.isWarnEnabled(null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isWarnEnabled(Marker marker) {
        void var1_1;
        FilterReply decision = this.callTurboFilters(marker, Level.WARN);
        if (decision == FilterReply.NEUTRAL) {
            return this.effectiveLevelInt <= 30000;
        }
        if (decision == FilterReply.DENY) {
            return false;
        }
        if (decision == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isEnabledFor(Marker marker, Level level) {
        void var1_1;
        FilterReply decision = this.callTurboFilters(marker, level);
        if (decision == FilterReply.NEUTRAL) {
            void var2_2;
            return this.effectiveLevelInt <= var2_2.levelInt;
        }
        if (decision == FilterReply.DENY) {
            return false;
        }
        if (decision == FilterReply.ACCEPT) {
            return true;
        }
        throw new IllegalStateException("Unknown FilterReply value: " + String.valueOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isEnabledFor(Level level) {
        void var1_1;
        return this.isEnabledFor(null, (Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(String msg) {
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, (String)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, (String)var1_1, null, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, null, Level.WARN, (String)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, null, Level.WARN, (String)var1_1, var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(String format, Object ... argArray) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, (String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(Marker marker, String msg) {
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(Marker marker, String format, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_1(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(Marker marker, String format, Object ... argArray) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, (Object[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(Marker marker, String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_2(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, var3_3, arg2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(Marker marker, String msg, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.filterAndLog_0_Or3Plus(FQCN, (Marker)var1_1, Level.WARN, (String)var2_2, null, (Throwable)var3_3);
    }

    public final boolean isAdditive() {
        return this.additive;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAdditive(boolean additive) {
        void var1_1;
        this.additive = var1_1;
    }

    public final String toString() {
        return "Logger[" + this.name + "]";
    }

    /*
     * WARNING - void declaration
     */
    private FilterReply callTurboFilters(Marker marker, Level level) {
        void var2_2;
        void var1_1;
        return this.loggerContext.getTurboFilterChainDecision_0_3OrMore((Marker)var1_1, this, (Level)var2_2, null, null, null);
    }

    public final LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    /*
     * WARNING - void declaration
     */
    public final LoggingEventBuilder makeLoggingEventBuilder(org.slf4j.event.Level level) {
        void var1_1;
        return new DefaultLoggingEventBuilder((org.slf4j.Logger)this, (org.slf4j.event.Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void log(Marker marker, String fqcn, int levelInt, String message, Object[] argArray, Throwable t) {
        void var3_4;
        void var1_1;
        void var2_2;
        Level level = Level.fromLocationAwareLoggerInteger(levelInt);
        this.filterAndLog_0_Or3Plus((String)var2_2, (Marker)var1_1, (Level)var3_4, message, argArray, t);
    }

    /*
     * WARNING - void declaration
     */
    public final void log(org.slf4j.event.LoggingEvent slf4jEvent) {
        void var1_1;
        org.slf4j.event.Level level = slf4jEvent.getLevel();
        Level logbackLevel = Level.convertAnSLF4JLevel(level);
        String callerBoundary = slf4jEvent.getCallerBoundary();
        if (callerBoundary == null) {
            callerBoundary = FQCN;
        }
        LoggingEvent lle = new LoggingEvent(callerBoundary, this, logbackLevel, slf4jEvent.getMessage(), slf4jEvent.getThrowable(), slf4jEvent.getArgumentArray());
        List markers = slf4jEvent.getMarkers();
        if (markers != null) {
            void var3_3;
            var3_3.forEach(m -> {
                void var1_1;
                lle.addMarker((Marker)var1_1);
            });
        }
        lle.setKeyValuePairs(var1_1.getKeyValuePairs());
        this.callAppenders((ILoggingEvent)level);
    }

    protected final Object readResolve() throws ObjectStreamException {
        return LoggerFactory.getLogger((String)this.getName());
    }
}

