/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.MenuPosition;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Landroidx/compose/material3/internal/WindowAlignmentMarginPosition;", "", "<init>", "()V", "Horizontal", "Vertical"})
@Immutable
public final class WindowAlignmentMarginPosition {
    public static final WindowAlignmentMarginPosition INSTANCE = new WindowAlignmentMarginPosition();

    private WindowAlignmentMarginPosition() {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Immutable
    public static final class Horizontal
    implements MenuPosition.Horizontal {
        private final Alignment.Horizontal alignment;
        private final int margin;

        /*
         * WARNING - void declaration
         */
        public Horizontal(Alignment.Horizontal alignment, int margin) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
            this.alignment = var1_1;
            this.margin = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int position-95KtPRI(IntRect anchorBounds, long windowSize, int menuWidth, LayoutDirection layoutDirection) {
            void var2_3;
            Intrinsics.checkNotNullParameter((Object)anchorBounds, (String)"anchorBounds");
            Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
            if (menuWidth >= IntSize.getWidth-impl((long)windowSize) - 2 * this.margin) {
                return Alignment.Companion.getCenterHorizontally().align(menuWidth, IntSize.getWidth-impl((long)windowSize), layoutDirection);
            }
            int n = this.alignment.align(menuWidth, IntSize.getWidth-impl((long)windowSize), layoutDirection);
            return RangesKt.coerceIn((int)n, (int)this.margin, (int)(IntSize.getWidth-impl((long)var2_3) - this.margin - menuWidth));
        }

        public final String toString() {
            return "Horizontal(alignment=" + this.alignment + ", margin=" + this.margin + ')';
        }

        public final int hashCode() {
            int n = this.alignment.hashCode();
            n = n * 31 + Integer.hashCode(this.margin);
            return n;
        }

        public final boolean equals(Object other) {
            Horizontal horizontal;
            if (this == other) {
                return true;
            }
            if (!(other instanceof Horizontal)) {
                return false;
            }
            horizontal = horizontal;
            if (!Intrinsics.areEqual((Object)this.alignment, (Object)horizontal.alignment)) {
                return false;
            }
            return this.margin == horizontal.margin;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Immutable
    public static final class Vertical
    implements MenuPosition.Vertical {
        private final Alignment.Vertical alignment;
        private final int margin;

        /*
         * WARNING - void declaration
         */
        public Vertical(Alignment.Vertical alignment, int margin) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
            this.alignment = var1_1;
            this.margin = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int position-JVtK1S4(IntRect anchorBounds, long windowSize, int menuHeight) {
            void var2_3;
            Intrinsics.checkNotNullParameter((Object)anchorBounds, (String)"anchorBounds");
            if (menuHeight >= IntSize.getHeight-impl((long)windowSize) - 2 * this.margin) {
                return Alignment.Companion.getCenterVertically().align(menuHeight, IntSize.getHeight-impl((long)windowSize));
            }
            int n = this.alignment.align(menuHeight, IntSize.getHeight-impl((long)windowSize));
            return RangesKt.coerceIn((int)n, (int)this.margin, (int)(IntSize.getHeight-impl((long)var2_3) - this.margin - menuHeight));
        }

        public final String toString() {
            return "Vertical(alignment=" + this.alignment + ", margin=" + this.margin + ')';
        }

        public final int hashCode() {
            int n = this.alignment.hashCode();
            n = n * 31 + Integer.hashCode(this.margin);
            return n;
        }

        public final boolean equals(Object other) {
            Vertical vertical;
            if (this == other) {
                return true;
            }
            if (!(other instanceof Vertical)) {
                return false;
            }
            vertical = vertical;
            if (!Intrinsics.areEqual((Object)this.alignment, (Object)vertical.alignment)) {
                return false;
            }
            return this.margin == vertical.margin;
        }
    }
}

