/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.MenuPosition;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Landroidx/compose/material3/internal/AnchorAlignmentOffsetPosition;", "", "<init>", "()V", "Horizontal", "Vertical"})
@Immutable
public final class AnchorAlignmentOffsetPosition {
    public static final AnchorAlignmentOffsetPosition INSTANCE = new AnchorAlignmentOffsetPosition();

    private AnchorAlignmentOffsetPosition() {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Immutable
    public static final class Horizontal
    implements MenuPosition.Horizontal {
        private final Alignment.Horizontal menuAlignment;
        private final Alignment.Horizontal anchorAlignment;
        private final int offset;

        /*
         * WARNING - void declaration
         */
        public Horizontal(Alignment.Horizontal menuAlignment, Alignment.Horizontal anchorAlignment, int offset) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)menuAlignment, (String)"menuAlignment");
            Intrinsics.checkNotNullParameter((Object)anchorAlignment, (String)"anchorAlignment");
            this.menuAlignment = var1_1;
            this.anchorAlignment = var2_2;
            this.offset = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int position-95KtPRI(IntRect anchorBounds, long windowSize, int menuWidth, LayoutDirection layoutDirection) {
            void var3_6;
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)anchorBounds, (String)"anchorBounds");
            Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
            int anchorAlignmentOffset = this.anchorAlignment.align(0, anchorBounds.getWidth(), layoutDirection);
            int menuAlignmentOffset = -this.menuAlignment.align(0, menuWidth, layoutDirection);
            int resolvedOffset = layoutDirection == LayoutDirection.Ltr ? this.offset : -this.offset;
            return var1_1.getLeft() + var2_3 + var3_6 + resolvedOffset;
        }

        public final String toString() {
            return "Horizontal(menuAlignment=" + this.menuAlignment + ", anchorAlignment=" + this.anchorAlignment + ", offset=" + this.offset + ')';
        }

        public final int hashCode() {
            int n = this.menuAlignment.hashCode();
            n = n * 31 + this.anchorAlignment.hashCode();
            n = n * 31 + Integer.hashCode(this.offset);
            return n;
        }

        public final boolean equals(Object other) {
            Horizontal horizontal;
            if (this == other) {
                return true;
            }
            if (!(other instanceof Horizontal)) {
                return false;
            }
            horizontal = horizontal;
            if (!Intrinsics.areEqual((Object)this.menuAlignment, (Object)horizontal.menuAlignment)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.anchorAlignment, (Object)horizontal.anchorAlignment)) {
                return false;
            }
            return this.offset == horizontal.offset;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Immutable
    public static final class Vertical
    implements MenuPosition.Vertical {
        private final Alignment.Vertical menuAlignment;
        private final Alignment.Vertical anchorAlignment;
        private final int offset;

        /*
         * WARNING - void declaration
         */
        public Vertical(Alignment.Vertical menuAlignment, Alignment.Vertical anchorAlignment, int offset) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)menuAlignment, (String)"menuAlignment");
            Intrinsics.checkNotNullParameter((Object)anchorAlignment, (String)"anchorAlignment");
            this.menuAlignment = var1_1;
            this.anchorAlignment = var2_2;
            this.offset = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int position-JVtK1S4(IntRect anchorBounds, long windowSize, int menuHeight) {
            void var3_5;
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)anchorBounds, (String)"anchorBounds");
            int anchorAlignmentOffset = this.anchorAlignment.align(0, anchorBounds.getHeight());
            int menuAlignmentOffset = -this.menuAlignment.align(0, menuHeight);
            return var1_1.getTop() + var2_3 + var3_5 + this.offset;
        }

        public final String toString() {
            return "Vertical(menuAlignment=" + this.menuAlignment + ", anchorAlignment=" + this.anchorAlignment + ", offset=" + this.offset + ')';
        }

        public final int hashCode() {
            int n = this.menuAlignment.hashCode();
            n = n * 31 + this.anchorAlignment.hashCode();
            n = n * 31 + Integer.hashCode(this.offset);
            return n;
        }

        public final boolean equals(Object other) {
            Vertical vertical;
            if (this == other) {
                return true;
            }
            if (!(other instanceof Vertical)) {
                return false;
            }
            vertical = vertical;
            if (!Intrinsics.areEqual((Object)this.menuAlignment, (Object)vertical.menuAlignment)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.anchorAlignment, (Object)vertical.anchorAlignment)) {
                return false;
            }
            return this.offset == vertical.offset;
        }
    }
}

