/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.HttpMethod;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.cio.ChunkedTransferEncodingKt;
import io.ktor.http.cio.ConnectionOptions;
import io.ktor.http.cio.HttpHeadersMap;
import io.ktor.http.cio.Request;
import io.ktor.http.cio.internals.CharsKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelOperationsKt;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelOperationsKt;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a)\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000b\u001a;\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u000b\u001aF\u0010\u0019\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a<\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0087@\u00a2\u0006\u0004\b\u0019\u0010\u001b\u001a(\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0004\b\u0019\u0010\u001e\u001a\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001f\u0010 "}, d2={"Lio/ktor/http/HttpMethod;", "method", "", "upgrade", "Lio/ktor/http/cio/ConnectionOptions;", "connectionOptions", "", "expectHttpUpgrade", "(Lio/ktor/http/HttpMethod;Ljava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;)Z", "Lio/ktor/http/cio/Request;", "request", "(Lio/ktor/http/cio/Request;)Z", "", "contentLength", "transferEncoding", "contentType", "expectHttpBody", "(Lio/ktor/http/HttpMethod;JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Ljava/lang/CharSequence;)Z", "Lio/ktor/http/HttpProtocolVersion;", "version", "Lio/ktor/utils/io/ByteReadChannel;", "input", "Lio/ktor/utils/io/ByteWriteChannel;", "out", "", "parseHttpBody", "(Lio/ktor/http/HttpProtocolVersion;JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/http/cio/HttpHeadersMap;", "headers", "(Lio/ktor/http/cio/HttpHeadersMap;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isTransferEncodingChunked", "(Ljava/lang/CharSequence;)Z"})
@SourceDebugExtension(value={"SMAP\nHttpBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpBody.kt\nio/ktor/http/cio/HttpBodyKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1863#2,2:178\n*S KotlinDebug\n*F\n+ 1 HttpBody.kt\nio/ktor/http/cio/HttpBodyKt\n*L\n158#1:178,2\n*E\n"})
public final class HttpBodyKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean expectHttpUpgrade(HttpMethod method, CharSequence upgrade, ConnectionOptions connectionOptions) {
        void var1_1;
        HttpMethod httpMethod;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.Companion.getGet()) && var1_1 != null) {
            void var2_2;
            void v0 = var2_2;
            boolean bl = v0 != null ? v0.getUpgrade() : false;
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public static final boolean expectHttpUpgrade(Request request) {
        Request request2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return HttpBodyKt.expectHttpUpgrade(request.getMethod(), request.getHeaders().get("Upgrade"), ConnectionOptions.Companion.parse(request2.getHeaders().get("Connection")));
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean expectHttpBody(HttpMethod method, long contentLength, CharSequence transferEncoding, ConnectionOptions connectionOptions, CharSequence contentType) {
        HttpMethod httpMethod;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (transferEncoding != null) {
            void var3_2;
            HttpBodyKt.isTransferEncodingChunked((CharSequence)var3_2);
            return true;
        }
        if (contentLength != -1L) {
            void var1_1;
            return var1_1 > 0L;
        }
        if (Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getGet()) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getHead()) || Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.Companion.getOptions())) {
            return false;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        return connectionOptions2 != null ? connectionOptions2.getClose() : false;
    }

    public static final boolean expectHttpBody(Request request) {
        Request request2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CharSequence charSequence = request.getHeaders().get("Content-Length");
        return HttpBodyKt.expectHttpBody(request.getMethod(), charSequence != null ? CharsKt.parseDecLong(charSequence) : -1L, request.getHeaders().get("Transfer-Encoding"), ConnectionOptions.Companion.parse(request.getHeaders().get("Connection")), request2.getHeaders().get("Content-Type"));
    }

    /*
     * WARNING - void declaration
     */
    public static final Object parseHttpBody(HttpProtocolVersion version, long contentLength, CharSequence transferEncoding, ConnectionOptions connectionOptions, ByteReadChannel input, ByteWriteChannel out, Continuation<? super Unit> $completion) {
        Object object;
        void var3_2;
        if (transferEncoding != null && HttpBodyKt.isTransferEncodingChunked((CharSequence)var3_2)) {
            Object object2 = ChunkedTransferEncodingKt.decodeChunked(input, out, $completion);
            if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object2;
            }
            return Unit.INSTANCE;
        }
        if (contentLength != -1L) {
            void var1_1;
            Object object3 = ByteReadChannelOperationsKt.copyTo((ByteReadChannel)input, (ByteWriteChannel)out, (long)var1_1, $completion);
            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object3;
            }
            return Unit.INSTANCE;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        boolean bl = connectionOptions2 != null ? connectionOptions2.getClose() : false;
        if (bl || connectionOptions == null && Intrinsics.areEqual((Object)version, (Object)HttpProtocolVersion.Companion.getHTTP_1_0())) {
            Object object4 = ByteReadChannelOperationsKt.copyTo((ByteReadChannel)input, (ByteWriteChannel)out, (long)Long.MAX_VALUE, $completion);
            if (object4 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object4;
            }
            return Unit.INSTANCE;
        }
        Object cause = new IllegalStateException("Failed to parse request body: request body length should be specified,\nchunked transfer encoding should be used or\nkeep-alive should be disabled (connection: close)");
        ByteWriteChannelOperationsKt.close((ByteWriteChannel)out, (Throwable)((Throwable)object));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Please use method with version parameter", level=DeprecationLevel.ERROR)
    public static final Object parseHttpBody(long contentLength, CharSequence transferEncoding, ConnectionOptions connectionOptions, ByteReadChannel input, ByteWriteChannel out, Continuation<? super Unit> $completion) {
        void var3_2;
        void var2_1;
        long l;
        Object object = HttpBodyKt.parseHttpBody(null, l, (CharSequence)var2_1, (ConnectionOptions)var3_2, input, out, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static final Object parseHttpBody(HttpHeadersMap headers, ByteReadChannel input, ByteWriteChannel out, Continuation<? super Unit> $completion) {
        void var3_3;
        void var2_2;
        void var1_1;
        HttpHeadersMap httpHeadersMap;
        CharSequence charSequence = headers.get("Content-Length");
        Object object = HttpBodyKt.parseHttpBody(null, charSequence != null ? CharsKt.parseDecLong(charSequence) : -1L, headers.get("Transfer-Encoding"), ConnectionOptions.Companion.parse(httpHeadersMap.get("Connection")), (ByteReadChannel)var1_1, (ByteWriteChannel)var2_2, (Continuation<? super Unit>)var3_3);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isTransferEncodingChunked(CharSequence transferEncoding) {
        void var1_1;
        if (CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "chunked", 3, null)) {
            return true;
        }
        if (CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "identity", 3, null)) {
            return false;
        }
        boolean chunked = false;
        String[] stringArray = new String[1];
        Object object = stringArray;
        stringArray[0] = ",";
        object = StringsKt.split$default((CharSequence)transferEncoding, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = object.iterator();
        while (object.hasNext()) {
            String name;
            Object object2 = object.next();
            object2 = (String)object2;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)name, (Object)"chunked")) {
                if (chunked) {
                    throw new IllegalArgumentException("Double-chunked TE is not supported: " + transferEncoding);
                }
                chunked = true;
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"identity")) continue;
            throw new IllegalArgumentException("Unsupported transfer encoding " + object2);
        }
        return (boolean)var1_1;
    }
}

