/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.SQLException;
import org.sqlite.core.DB;

public class SafeStmtPtr {
    private final DB db;
    private final long ptr;
    private volatile boolean closed = false;
    private int closedRC;
    private SQLException closeException;

    /*
     * WARNING - void declaration
     */
    public SafeStmtPtr(DB db, long ptr) {
        void var2_2;
        void var1_1;
        this.db = var1_1;
        this.ptr = var2_2;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int close() throws SQLException {
        DB dB = this.db;
        synchronized (dB) {
            return this.internalClose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private int internalClose() throws SQLException {
        try {
            if (this.closed) {
                if (this.closeException != null) {
                    throw this.closeException;
                }
                int n = this.closedRC;
                return n;
            }
            SafeStmtPtr safeStmtPtr = this;
            int n = this.closedRC = this.db.finalize(safeStmtPtr, safeStmtPtr.ptr);
            return n;
        }
        catch (SQLException ex) {
            void var1_3;
            this.closeException = ex;
            throw var1_3;
        }
        finally {
            this.closed = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Throwable> int safeRunInt(SafePtrIntFunction<E> run) throws SQLException, E {
        DB dB = this.db;
        synchronized (dB) {
            void var1_1;
            this.ensureOpen();
            return var1_1.run(this.db, this.ptr);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Throwable> long safeRunLong(SafePtrLongFunction<E> run) throws SQLException, E {
        DB dB = this.db;
        synchronized (dB) {
            void var1_1;
            this.ensureOpen();
            return var1_1.run(this.db, this.ptr);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Throwable> double safeRunDouble(SafePtrDoubleFunction<E> run) throws SQLException, E {
        DB dB = this.db;
        synchronized (dB) {
            void var1_1;
            this.ensureOpen();
            return var1_1.run(this.db, this.ptr);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T, E extends Throwable> T safeRun(SafePtrFunction<T, E> run) throws SQLException, E {
        DB dB = this.db;
        synchronized (dB) {
            void var1_1;
            this.ensureOpen();
            return var1_1.run(this.db, this.ptr);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <E extends Throwable> void safeRunConsume(SafePtrConsumer<E> run) throws SQLException, E {
        DB dB = this.db;
        synchronized (dB) {
            void var1_1;
            this.ensureOpen();
            var1_1.run(this.db, this.ptr);
            return;
        }
    }

    private void ensureOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("stmt pointer is closed");
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SafeStmtPtr that = (SafeStmtPtr)o;
        return this.ptr == var1_1.ptr;
    }

    public int hashCode() {
        return Long.hashCode(this.ptr);
    }

    @FunctionalInterface
    public static interface SafePtrConsumer<E extends Throwable> {
        public void run(DB var1, long var2) throws E;
    }

    @FunctionalInterface
    public static interface SafePtrFunction<T, E extends Throwable> {
        public T run(DB var1, long var2) throws E;
    }

    @FunctionalInterface
    public static interface SafePtrDoubleFunction<E extends Throwable> {
        public double run(DB var1, long var2) throws E;
    }

    @FunctionalInterface
    public static interface SafePtrLongFunction<E extends Throwable> {
        public long run(DB var1, long var2) throws E;
    }

    @FunctionalInterface
    public static interface SafePtrIntFunction<E extends Throwable> {
        public int run(DB var1, long var2) throws E;
    }
}

