/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.BusyHandler;
import org.sqlite.Collation;
import org.sqlite.Function;
import org.sqlite.ProgressHandler;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteJDBCLoader;
import org.sqlite.core.DB;
import org.sqlite.core.SafeStmtPtr;

public final class NativeDB
extends DB {
    private static final Logger logger = LoggerFactory.getLogger(NativeDB.class);
    private static final int DEFAULT_BACKUP_BUSY_SLEEP_TIME_MILLIS = 100;
    private static final int DEFAULT_BACKUP_NUM_BUSY_BEFORE_FAIL = 3;
    private static final int DEFAULT_PAGES_PER_BACKUP_STEP = 100;
    private long pointer = 0L;
    private static boolean isLoaded;
    private static boolean loadSucceeded;
    private long busyHandler = 0L;
    private long commitListener = 0L;
    private long updateListener = 0L;
    private long progressHandler;

    /*
     * WARNING - void declaration
     */
    public NativeDB(String url, String fileName, SQLiteConfig config) throws SQLException {
        super((String)var1_1, (String)var2_2, (SQLiteConfig)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public static boolean load() throws Exception {
        if (isLoaded) {
            return loadSucceeded;
        }
        try {
            loadSucceeded = SQLiteJDBCLoader.initialize();
        }
        finally {
            isLoaded = true;
        }
        return loadSucceeded;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final synchronized void _open(String file, int openFlags) throws SQLException {
        void var2_2;
        void var1_1;
        this._open_utf8(NativeDB.stringToUtf8ByteArray((String)var1_1), (int)var2_2);
    }

    final synchronized native void _open_utf8(byte[] var1, int var2) throws SQLException;

    @Override
    protected final synchronized native void _close() throws SQLException;

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int _exec(String sql) throws SQLException {
        void var1_1;
        if (logger.isTraceEnabled()) {
            logger.trace("DriverManager [{}] [SQLite EXEC] {}", (Object)Thread.currentThread().getName(), (Object)sql);
        }
        return this._exec_utf8(NativeDB.stringToUtf8ByteArray((String)var1_1));
    }

    final synchronized native int _exec_utf8(byte[] var1) throws SQLException;

    @Override
    public final synchronized native int shared_cache(boolean var1);

    @Override
    public final synchronized native int enable_load_extension(boolean var1);

    @Override
    public final native void interrupt();

    @Override
    public final synchronized native void busy_timeout(int var1);

    @Override
    public final synchronized native void busy_handler(BusyHandler var1);

    /*
     * WARNING - void declaration
     */
    @Override
    protected final synchronized SafeStmtPtr prepare(String sql) throws SQLException {
        void var1_1;
        if (logger.isTraceEnabled()) {
            logger.trace("DriverManager [{}] [SQLite EXEC] {}", (Object)Thread.currentThread().getName(), (Object)sql);
        }
        NativeDB nativeDB = this;
        return new SafeStmtPtr(nativeDB, nativeDB.prepare_utf8(NativeDB.stringToUtf8ByteArray((String)var1_1)));
    }

    final synchronized native long prepare_utf8(byte[] var1) throws SQLException;

    @Override
    final synchronized String errmsg() {
        return NativeDB.utf8ByteBufferToString(this.errmsg_utf8());
    }

    final synchronized native ByteBuffer errmsg_utf8();

    @Override
    public final synchronized String libversion() {
        return NativeDB.utf8ByteBufferToString(this.libversion_utf8());
    }

    final native ByteBuffer libversion_utf8();

    @Override
    public final synchronized native long changes();

    @Override
    public final synchronized native long total_changes();

    @Override
    protected final synchronized native int finalize(long var1);

    @Override
    public final synchronized native int step(long var1);

    @Override
    public final synchronized native int reset(long var1);

    @Override
    public final synchronized native int clear_bindings(long var1);

    @Override
    final synchronized native int bind_parameter_count(long var1);

    @Override
    public final synchronized native int column_count(long var1);

    @Override
    public final synchronized native int column_type(long var1, int var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized String column_decltype(long stmt, int col) {
        void var3_2;
        void var1_1;
        return NativeDB.utf8ByteBufferToString(this.column_decltype_utf8((long)var1_1, (int)var3_2));
    }

    final synchronized native ByteBuffer column_decltype_utf8(long var1, int var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized String column_table_name(long stmt, int col) {
        void var3_2;
        void var1_1;
        return NativeDB.utf8ByteBufferToString(this.column_table_name_utf8((long)var1_1, (int)var3_2));
    }

    final synchronized native ByteBuffer column_table_name_utf8(long var1, int var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized String column_name(long stmt, int col) {
        void var3_2;
        void var1_1;
        return NativeDB.utf8ByteBufferToString(this.column_name_utf8((long)var1_1, (int)var3_2));
    }

    final synchronized native ByteBuffer column_name_utf8(long var1, int var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized String column_text(long stmt, int col) {
        void var3_2;
        void var1_1;
        return NativeDB.utf8ByteBufferToString(this.column_text_utf8((long)var1_1, (int)var3_2));
    }

    final synchronized native ByteBuffer column_text_utf8(long var1, int var3);

    @Override
    public final synchronized native byte[] column_blob(long var1, int var3);

    @Override
    public final synchronized native double column_double(long var1, int var3);

    @Override
    public final synchronized native long column_long(long var1, int var3);

    @Override
    public final synchronized native int column_int(long var1, int var3);

    @Override
    final synchronized native int bind_null(long var1, int var3);

    @Override
    final synchronized native int bind_int(long var1, int var3, int var4);

    @Override
    final synchronized native int bind_long(long var1, int var3, long var4);

    @Override
    final synchronized native int bind_double(long var1, int var3, double var4);

    /*
     * WARNING - void declaration
     */
    @Override
    final synchronized int bind_text(long stmt, int pos, String v) {
        void var3_2;
        void var1_1;
        return this.bind_text_utf8((long)var1_1, (int)var3_2, NativeDB.stringToUtf8ByteArray(v));
    }

    final synchronized native int bind_text_utf8(long var1, int var3, byte[] var4);

    @Override
    final synchronized native int bind_blob(long var1, int var3, byte[] var4);

    @Override
    public final synchronized native void result_null(long var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void result_text(long context, String val) {
        void var3_2;
        void var1_1;
        this.result_text_utf8((long)var1_1, NativeDB.stringToUtf8ByteArray((String)var3_2));
    }

    final synchronized native void result_text_utf8(long var1, byte[] var3);

    @Override
    public final synchronized native void result_blob(long var1, byte[] var3);

    @Override
    public final synchronized native void result_double(long var1, double var3);

    @Override
    public final synchronized native void result_long(long var1, long var3);

    @Override
    public final synchronized native void result_int(long var1, int var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void result_error(long context, String err) {
        void var3_2;
        void var1_1;
        this.result_error_utf8((long)var1_1, NativeDB.stringToUtf8ByteArray((String)var3_2));
    }

    final synchronized native void result_error_utf8(long var1, byte[] var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized String value_text(Function f, int arg) {
        void var2_2;
        void var1_1;
        return NativeDB.utf8ByteBufferToString(this.value_text_utf8((Function)var1_1, (int)var2_2));
    }

    final synchronized native ByteBuffer value_text_utf8(Function var1, int var2);

    @Override
    public final synchronized native byte[] value_blob(Function var1, int var2);

    @Override
    public final synchronized native double value_double(Function var1, int var2);

    @Override
    public final synchronized native long value_long(Function var1, int var2);

    @Override
    public final synchronized native int value_int(Function var1, int var2);

    @Override
    public final synchronized native int value_type(Function var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int create_function(String name, Function func, int nArgs, int flags) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        NativeDB nativeDB = this;
        return nativeDB.create_function_utf8(nativeDB.nameToUtf8ByteArray("function", (String)var1_1), (Function)var2_2, (int)var3_3, flags);
    }

    final synchronized native int create_function_utf8(byte[] var1, Function var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int destroy_function(String name) throws SQLException {
        void var1_1;
        NativeDB nativeDB = this;
        return nativeDB.destroy_function_utf8(nativeDB.nameToUtf8ByteArray("function", (String)var1_1));
    }

    final synchronized native int destroy_function_utf8(byte[] var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int create_collation(String name, Collation coll) throws SQLException {
        void var2_2;
        void var1_1;
        NativeDB nativeDB = this;
        return nativeDB.create_collation_utf8(nativeDB.nameToUtf8ByteArray("collation", (String)var1_1), (Collation)var2_2);
    }

    final synchronized native int create_collation_utf8(byte[] var1, Collation var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int destroy_collation(String name) throws SQLException {
        void var1_1;
        NativeDB nativeDB = this;
        return nativeDB.destroy_collation_utf8(nativeDB.nameToUtf8ByteArray("collation", (String)var1_1));
    }

    final synchronized native int destroy_collation_utf8(byte[] var1);

    @Override
    public final synchronized native int limit(int var1, int var2) throws SQLException;

    /*
     * WARNING - void declaration
     */
    private byte[] nameToUtf8ByteArray(String nameType, String name) throws SQLException {
        void var3_3;
        byte[] nameUtf8 = NativeDB.stringToUtf8ByteArray(name);
        if (name == null || "".equals(name) || nameUtf8.length > 255) {
            void var2_2;
            void var1_1;
            throw new SQLException("invalid " + (String)var1_1 + " name: '" + (String)var2_2 + "'");
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int backup(String dbName, String destFileName, DB.ProgressObserver observer) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.backup(NativeDB.stringToUtf8ByteArray((String)var1_1), NativeDB.stringToUtf8ByteArray((String)var2_2), (DB.ProgressObserver)var3_3, 100, 3, 100);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int backup(String dbName, String destFileName, DB.ProgressObserver observer, int sleepTimeMillis, int nTimeouts, int pagesPerStep) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.backup(NativeDB.stringToUtf8ByteArray((String)var1_1), NativeDB.stringToUtf8ByteArray((String)var2_2), (DB.ProgressObserver)var3_3, sleepTimeMillis, nTimeouts, pagesPerStep);
    }

    final synchronized native int backup(byte[] var1, byte[] var2, DB.ProgressObserver var3, int var4, int var5, int var6) throws SQLException;

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int restore(String dbName, String sourceFileName, DB.ProgressObserver observer) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return ((DB)this).restore((String)var1_1, (String)var2_2, (DB.ProgressObserver)var3_3, 100, 3, 100);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int restore(String dbName, String sourceFileName, DB.ProgressObserver observer, int sleepTimeMillis, int nTimeouts, int pagesPerStep) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.restore(NativeDB.stringToUtf8ByteArray((String)var1_1), NativeDB.stringToUtf8ByteArray((String)var2_2), (DB.ProgressObserver)var3_3, sleepTimeMillis, nTimeouts, pagesPerStep);
    }

    final synchronized native int restore(byte[] var1, byte[] var2, DB.ProgressObserver var3, int var4, int var5, int var6) throws SQLException;

    @Override
    final synchronized native boolean[][] column_metadata(long var1);

    @Override
    final synchronized native void set_commit_listener(boolean var1);

    @Override
    final synchronized native void set_update_listener(boolean var1);

    static void throwex(String msg) throws SQLException {
        String string;
        throw new SQLException(string);
    }

    static byte[] stringToUtf8ByteArray(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    static String utf8ByteBufferToString(ByteBuffer buffer) {
        void var1_1;
        ByteBuffer byteBuffer;
        if (buffer == null) {
            return null;
        }
        byte[] buff = new byte[buffer.remaining()];
        byteBuffer.get(buff);
        return new String((byte[])var1_1, StandardCharsets.UTF_8);
    }

    @Override
    public final synchronized native void register_progress_handler(int var1, ProgressHandler var2) throws SQLException;

    @Override
    public final synchronized native void clear_progress_handler() throws SQLException;

    final long getBusyHandler() {
        return this.busyHandler;
    }

    final long getCommitListener() {
        return this.commitListener;
    }

    final long getUpdateListener() {
        return this.updateListener;
    }

    final long getProgressHandler() {
        return this.progressHandler;
    }

    @Override
    public final synchronized native byte[] serialize(String var1) throws SQLException;

    @Override
    public final synchronized native void deserialize(String var1, byte[] var2) throws SQLException;

    static {
        if ("The Android Project".equals(System.getProperty("java.vm.vendor"))) {
            System.loadLibrary("sqlitejdbc");
            isLoaded = true;
            loadSucceeded = true;
        } else {
            isLoaded = false;
            loadSucceeded = false;
        }
    }
}

