/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.Date;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.core.DB;
import org.sqlite.date.FastDateFormat;
import org.sqlite.jdbc3.JDBC3Connection;
import org.sqlite.jdbc3.JDBC3Statement;
import org.sqlite.jdbc4.JDBC4Statement;

public abstract class CorePreparedStatement
extends JDBC4Statement {
    protected int columnCount;
    protected int paramCount;
    protected int batchQueryCount;

    /*
     * WARNING - void declaration
     */
    protected CorePreparedStatement(SQLiteConnection conn, String sql) throws SQLException {
        super(conn);
        DB dB;
        void var2_2;
        this.sql = var2_2;
        dB = ((SQLiteConnection)((Object)dB)).getDatabase();
        dB.prepare(this);
        this.rs.colsMeta = this.pointer.safeRun(DB::column_names);
        this.columnCount = this.pointer.safeRunInt(DB::column_count);
        this.paramCount = this.pointer.safeRunInt(DB::bind_parameter_count);
        this.batchQueryCount = 0;
        this.batch = null;
        this.batchPos = 0;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return Arrays.stream(((JDBC3Statement)this).executeLargeBatch()).mapToInt(l -> (int)l).toArray();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        if (this.batchQueryCount == 0) {
            return new long[0];
        }
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        CorePreparedStatement corePreparedStatement = this;
        return corePreparedStatement.withConnectionTimeout(() -> {
            try {
                long[] lArray = this.conn.getDatabase().executeBatch(this.pointer, this.batchQueryCount, this.batch, this.conn.getAutoCommit());
                return lArray;
            }
            finally {
                ((JDBC3Statement)this).clearBatch();
            }
        });
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchQueryCount = 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void batch(int pos, Object value) throws SQLException {
        void var2_2;
        this.checkOpen();
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
        }
        this.batch[this.batchPos + var1_1 - 1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void setDateByMilliseconds(int pos, Long value, Calendar calendar) throws SQLException {
        void var2_2;
        void var1_1;
        SQLiteConnectionConfig config = this.conn.getConnectionConfig();
        switch (config.getDateClass()) {
            case TEXT: {
                void var3_3;
                this.batch(pos, FastDateFormat.getInstance(config.getDateStringFormat(), var3_3.getTimeZone()).format(new Date(value)));
                return;
            }
            case REAL: {
                this.batch(pos, new Double((double)value.longValue() / 8.64E7 + 2440587.5));
                return;
            }
        }
        this.batch((int)var1_1, new Long(var2_2.longValue() / config.getDateMultiplier()));
    }
}

