/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.FileException;
import org.sqlite.NativeLibraryNotFoundException;
import org.sqlite.util.LibraryLoaderUtil;
import org.sqlite.util.OSInfo;
import org.sqlite.util.StringUtils;

public class SQLiteJDBCLoader {
    private static final Logger logger = LoggerFactory.getLogger(SQLiteJDBCLoader.class);
    private static final String LOCK_EXT = ".lck";
    private static boolean extracted = false;

    public static synchronized boolean initialize() throws Exception {
        if (!extracted) {
            SQLiteJDBCLoader.cleanup();
        }
        SQLiteJDBCLoader.loadSQLiteNativeLibrary();
        return extracted;
    }

    private static File getTempDir() {
        return new File(System.getProperty("org.sqlite.tmpdir", System.getProperty("java.io.tmpdir")));
    }

    /*
     * WARNING - void declaration
     */
    static void cleanup() {
        String searchPattern = "sqlite-" + SQLiteJDBCLoader.getVersion();
        try {
            Stream<Path> dirList2;
            block8: {
                block7: {
                    dirList2 = Files.list(SQLiteJDBCLoader.getTempDir().toPath());
                    try {
                        void var0;
                        dirList2.filter(arg_0 -> SQLiteJDBCLoader.lambda$cleanup$0((String)var0, arg_0)).forEach(nativeLib -> {
                            Path path = Paths.get(nativeLib + LOCK_EXT, new String[0]);
                            if (Files.notExists(path, new LinkOption[0])) {
                                try {
                                    Files.delete(nativeLib);
                                    return;
                                }
                                catch (Exception e) {
                                    void var0_1;
                                    logger.error("Failed to delete old native lib", (Throwable)var0_1);
                                }
                            }
                        });
                        if (dirList2 == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (dirList2 != null) {
                            try {
                                dirList2.close();
                            }
                            catch (Throwable dirList2) {
                                throwable.addSuppressed(dirList2);
                            }
                        }
                        throw throwable;
                    }
                    break block8;
                }
                return;
            }
            dirList2.close();
        }
        catch (IOException e) {
            void var1_4;
            logger.error("Failed to open directory", (Throwable)var1_4);
        }
    }

    public static boolean isNativeMode() throws Exception {
        SQLiteJDBCLoader.initialize();
        return extracted;
    }

    /*
     * WARNING - void declaration
     */
    static String md5sum(InputStream input) throws IOException {
        Object digest;
        InputStream in = new BufferedInputStream(input);
        try {
            void var2_4;
            digest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(in, (MessageDigest)digest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream md5out = new ByteArrayOutputStream();
            md5out.write(((MessageDigest)digest).digest());
            digest = var2_4.toString();
        }
        catch (NoSuchAlgorithmException e) {
            try {
                void var1_2;
                throw new IllegalStateException("MD5 algorithm is not available: " + var1_2);
            }
            catch (Throwable throwable) {
                InputStream inputStream;
                ((BufferedInputStream)inputStream).close();
                throw throwable;
            }
        }
        ((BufferedInputStream)in).close();
        return digest;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean contentsEquals(InputStream in1, InputStream in2) throws IOException {
        void var1_1;
        int n;
        if (!(in1 instanceof BufferedInputStream)) {
            in1 = new BufferedInputStream(in1);
        }
        if (!(in2 instanceof BufferedInputStream)) {
            in2 = new BufferedInputStream(in2);
        }
        int ch = in1.read();
        while (ch != -1) {
            int ch2 = in2.read();
            if (ch != n) {
                return false;
            }
            ch = in1.read();
        }
        n = var1_1.read();
        return n == -1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean extractAndLoadLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) throws FileException {
        InputStream nativeLibraryFilePath2 = libFolderForCurrentOS + "/" + libraryFileName;
        String uuid = UUID.randomUUID().toString();
        String extractedLibFileName2 = String.format("sqlite-%s-%s-%s", SQLiteJDBCLoader.getVersion(), uuid, libraryFileName);
        String extractedLckFileName = extractedLibFileName2 + LOCK_EXT;
        Path extractedLibFile = Paths.get(targetFolder, extractedLibFileName2);
        Path extractedLckFile = Paths.get(targetFolder, extractedLckFileName);
        try {
            try {
                try (InputStream reader = SQLiteJDBCLoader.getResourceAsStream((String)((Object)nativeLibraryFilePath2));){
                    if (Files.notExists(extractedLckFile, new LinkOption[0])) {
                        Files.createFile(extractedLckFile, new FileAttribute[0]);
                    }
                    Files.copy(reader, extractedLibFile, StandardCopyOption.REPLACE_EXISTING);
                }
                extractedLibFile.toFile().deleteOnExit();
                extractedLckFile.toFile().deleteOnExit();
            }
            catch (Throwable nativeLibraryFilePath2) {
                void var3_10;
                extractedLibFile.toFile().deleteOnExit();
                var3_10.toFile().deleteOnExit();
                throw nativeLibraryFilePath2;
            }
            extractedLibFile.toFile().setReadable(true);
            extractedLibFile.toFile().setWritable(true, true);
            extractedLibFile.toFile().setExecutable(true);
            try (InputStream nativeIn = SQLiteJDBCLoader.getResourceAsStream((String)((Object)nativeLibraryFilePath2));){
                void var1_5;
                void var2_9;
                InputStream extractedLibIn = Files.newInputStream(extractedLibFile, new OpenOption[0]);
                try {
                    if (!SQLiteJDBCLoader.contentsEquals(nativeIn, extractedLibIn)) {
                        throw new FileException(String.format("Failed to write a native library file at %s", extractedLibFile));
                    }
                    if (extractedLibIn == null) return SQLiteJDBCLoader.loadNativeLibrary((String)var2_9, (String)var1_5);
                }
                catch (Throwable extractedLibFileName2) {
                    if (extractedLibIn == null) throw extractedLibFileName2;
                    try {
                        InputStream inputStream;
                        inputStream.close();
                        throw extractedLibFileName2;
                    }
                    catch (Throwable throwable) {
                        extractedLibFileName2.addSuppressed(throwable);
                    }
                    throw extractedLibFileName2;
                }
                extractedLibIn.close();
                return SQLiteJDBCLoader.loadNativeLibrary((String)var2_9, (String)var1_5);
            }
        }
        catch (IOException e) {
            logger.error("Unexpected IOException", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static InputStream getResourceAsStream(String name) {
        URLConnection resolvedName = name.substring(1);
        ClassLoader classLoader = SQLiteJDBCLoader.class.getClassLoader();
        URLConnection url = classLoader.getResource((String)((Object)resolvedName));
        if (url == null) {
            return null;
        }
        try {
            URLConnection connection = ((URL)((Object)url)).openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException e) {
            void var0_1;
            logger.error("Could not connect", (Throwable)var0_1);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean loadNativeLibrary(String path, String name) {
        File file = new File(path, name);
        if (file.exists()) {
            try {
                System.load(new File(path, name).getAbsolutePath());
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                void var0_1;
                void var1_2;
                logger.error("Failed to load native library: {}. osinfo: {}", new Object[]{var1_2, OSInfo.getNativeLibFolderPathForCurrentOS(), var0_1});
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean loadNativeLibraryJdk() {
        try {
            System.loadLibrary("sqlitejdbc");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            void var0;
            logger.error("Failed to load native library through System.loadLibrary", (Throwable)var0);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void loadSQLiteNativeLibrary() throws Exception {
        void var0;
        boolean bl;
        if (extracted) {
            return;
        }
        LinkedList<Object> triedPaths = new LinkedList<Object>();
        String sqliteNativeLibraryPath = System.getProperty("org.sqlite.lib.path");
        String sqliteNativeLibraryName = System.getProperty("org.sqlite.lib.name");
        if (sqliteNativeLibraryName == null) {
            sqliteNativeLibraryName = LibraryLoaderUtil.getNativeLibName();
        }
        if (sqliteNativeLibraryPath != null) {
            if (SQLiteJDBCLoader.loadNativeLibrary(sqliteNativeLibraryPath, sqliteNativeLibraryName)) {
                extracted = true;
                return;
            }
            triedPaths.add(sqliteNativeLibraryPath);
        }
        if (bl = LibraryLoaderUtil.hasNativeLib(sqliteNativeLibraryPath = LibraryLoaderUtil.getNativeLibResourcePath(), sqliteNativeLibraryName)) {
            String[] stringArray;
            void var3_4;
            String tempFolder = SQLiteJDBCLoader.getTempDir().getAbsolutePath();
            if (SQLiteJDBCLoader.extractAndLoadLibraryFile(sqliteNativeLibraryPath, sqliteNativeLibraryName, (String)var3_4)) {
                extracted = true;
                return;
            }
            triedPaths.add(stringArray);
        }
        String string = System.getProperty("java.library.path", "");
        for (String ldPath : string.split(File.pathSeparator)) {
            if (ldPath.isEmpty()) continue;
            if (SQLiteJDBCLoader.loadNativeLibrary(ldPath, sqliteNativeLibraryName)) {
                extracted = true;
                return;
            }
            triedPaths.add(ldPath);
        }
        if (SQLiteJDBCLoader.loadNativeLibraryJdk()) {
            extracted = true;
            return;
        }
        extracted = false;
        throw new NativeLibraryNotFoundException(String.format("No native library found for os.name=%s, os.arch=%s, paths=[%s]", OSInfo.getOSName(), OSInfo.getArchName(), StringUtils.join((List<String>)var0, File.pathSeparator)));
    }

    private static void getNativeLibraryFolderForTheCurrentOS() {
        OSInfo.getOSName();
        OSInfo.getArchName();
    }

    /*
     * WARNING - void declaration
     */
    public static int getMajorVersion() {
        String[] c = SQLiteJDBCLoader.getVersion().split("\\.");
        if (c.length > 0) {
            void var0;
            return Integer.parseInt((String)var0[0]);
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int getMinorVersion() {
        String[] c = SQLiteJDBCLoader.getVersion().split("\\.");
        if (c.length > 1) {
            void var0;
            return Integer.parseInt((String)var0[1]);
        }
        return 0;
    }

    public static String getVersion() {
        return VersionHolder.VERSION;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$cleanup$0(String searchPattern, Path path) {
        String string;
        void var1_1;
        return !path.getFileName().toString().endsWith(LOCK_EXT) && var1_1.getFileName().toString().startsWith(string);
    }

    public static final class VersionHolder {
        private static final String VERSION;

        /*
         * WARNING - void declaration
         */
        static {
            void var1_1;
            URL versionFile = VersionHolder.class.getResource("/META-INF/maven/org.xerial/sqlite-jdbc/pom.properties");
            if (versionFile == null) {
                versionFile = VersionHolder.class.getResource("/META-INF/maven/org.xerial/sqlite-jdbc/VERSION");
            }
            String version = "unknown";
            try {
                if (versionFile != null) {
                    Properties versionData = new Properties();
                    versionData.load(versionFile.openStream());
                    version = versionData.getProperty("version", version);
                    version = version.trim().replaceAll("[^0-9\\.]", "");
                }
            }
            catch (IOException e) {
                void var2_3;
                void var0;
                LoggerFactory.getLogger(VersionHolder.class).error("Could not read version from file: {}", (Object)var0, (Object)var2_3);
            }
            VERSION = var1_1;
        }
    }
}

