/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.sqlite.SQLiteCommitListener;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.SQLiteLimits;
import org.sqlite.SQLiteUpdateListener;
import org.sqlite.core.CoreDatabaseMetaData;
import org.sqlite.core.DB;
import org.sqlite.core.NativeDB;
import org.sqlite.jdbc4.JDBC4DatabaseMetaData;

public abstract class SQLiteConnection
implements Connection {
    private static final String RESOURCE_NAME_PREFIX = ":resource:";
    private final DB db;
    private CoreDatabaseMetaData meta = null;
    private final SQLiteConnectionConfig connectionConfig;
    private SQLiteConfig.TransactionMode currentTransactionMode;
    private boolean firstStatementExecuted = false;

    /*
     * WARNING - void declaration
     */
    public SQLiteConnection(DB db) {
        void var1_1;
        this.db = db;
        this.connectionConfig = var1_1.getConfig().newConnectionConfig();
    }

    /*
     * WARNING - void declaration
     */
    public SQLiteConnection(String url, String fileName) throws SQLException {
        this((String)var1_1, (String)var2_2, new Properties());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SQLiteConnection(String url, String fileName, Properties prop) throws SQLException {
        DB newDB = null;
        try {
            void var3_5;
            this.db = newDB = SQLiteConnection.open(url, fileName, (Properties)var3_5);
            SQLiteConfig config = this.db.getConfig();
            this.connectionConfig = this.db.getConfig().newConnectionConfig();
            config.apply(this);
            this.currentTransactionMode = this.getDatabase().getConfig().getTransactionMode();
            this.firstStatementExecuted = false;
            return;
        }
        catch (Throwable t) {
            void var1_2;
            try {
                if (newDB != null) {
                    newDB.close();
                }
            }
            catch (Exception e) {
                void var2_4;
                t.addSuppressed((Throwable)var2_4);
            }
            throw var1_2;
        }
    }

    public SQLiteConfig.TransactionMode getCurrentTransactionMode() {
        return this.currentTransactionMode;
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentTransactionMode(SQLiteConfig.TransactionMode currentTransactionMode) {
        void var1_1;
        this.currentTransactionMode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFirstStatementExecuted(boolean firstStatementExecuted) {
        void var1_1;
        this.firstStatementExecuted = var1_1;
    }

    public boolean isFirstStatementExecuted() {
        return this.firstStatementExecuted;
    }

    public SQLiteConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public CoreDatabaseMetaData getSQLiteDatabaseMetaData() throws SQLException {
        this.checkOpen();
        if (this.meta == null) {
            this.meta = new JDBC4DatabaseMetaData(this);
        }
        return this.meta;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getSQLiteDatabaseMetaData();
    }

    public String getUrl() {
        return this.db.getUrl();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkCursor(int rst, int rsc, int rsh) throws SQLException {
        void var3_3;
        void var2_2;
        if (rst != 1003) {
            throw new SQLException("SQLite only supports TYPE_FORWARD_ONLY cursors");
        }
        if (var2_2 != 1007) {
            throw new SQLException("SQLite only supports CONCUR_READ_ONLY cursors");
        }
        if (var3_3 != 2) {
            throw new SQLException("SQLite only supports closing cursors at commit");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setTransactionMode(SQLiteConfig.TransactionMode mode) {
        void var1_1;
        this.connectionConfig.setTransactionMode((SQLiteConfig.TransactionMode)var1_1);
    }

    @Override
    public int getTransactionIsolation() {
        return this.connectionConfig.getTransactionIsolation();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        void var1_1;
        this.checkOpen();
        switch (level) {
            case 2: 
            case 4: 
            case 8: {
                this.getDatabase().exec("PRAGMA read_uncommitted = false;", this.getAutoCommit());
                break;
            }
            case 1: {
                this.getDatabase().exec("PRAGMA read_uncommitted = true;", this.getAutoCommit());
                break;
            }
            default: {
                throw new SQLException("Unsupported transaction isolation level: " + level + ". Must be one of TRANSACTION_READ_UNCOMMITTED, TRANSACTION_READ_COMMITTED, TRANSACTION_REPEATABLE_READ, or TRANSACTION_SERIALIZABLE in java.sql.Connection");
            }
        }
        this.connectionConfig.setTransactionIsolation((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static DB open(String url, String origFileName, Properties props) throws SQLException {
        void var3_5;
        void var2_4;
        void var1_3;
        NativeDB db;
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)props);
        String fileName = SQLiteConnection.extractPragmasFromFilename(url, origFileName, newProps);
        SQLiteConfig config = new SQLiteConfig(newProps);
        if (!(fileName.isEmpty() || ":memory:".equals(fileName) || fileName.startsWith("file:") || fileName.contains("mode=memory"))) {
            if (fileName.startsWith(RESOURCE_NAME_PREFIX)) {
                String resourceName = fileName.substring(10);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL resourceAddr = classLoader.getResource(resourceName);
                if (resourceAddr == null) {
                    try {
                        resourceAddr = new URL(resourceName);
                    }
                    catch (MalformedURLException e) {
                        throw new SQLException(String.format("resource %s not found: %s", resourceName, e));
                    }
                }
                try {
                    fileName = SQLiteConnection.extractResource(resourceAddr).getAbsolutePath();
                }
                catch (IOException e) {
                    void var0_2;
                    throw new SQLException(String.format("failed to load %s: %s", resourceName, var0_2));
                }
            }
            File file = new File(fileName).getAbsoluteFile();
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                for (File up = parent; up != null && !up.exists(); up = up.getParentFile()) {
                    parent = up;
                }
                throw new SQLException("path to '" + fileName + "': '" + parent + "' does not exist");
            }
            try {
                if (!file.exists() && file.createNewFile()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                throw new SQLException("opening db: '" + fileName + "': " + e.getMessage());
            }
            fileName = file.getAbsolutePath();
        }
        try {
            String string;
            NativeDB.load();
            db = new NativeDB(string, fileName, config);
        }
        catch (Exception e) {
            SQLException err = new SQLException("Error opening connection");
            err.initCause(e);
            throw err;
        }
        db.open((String)var1_3, var2_4.getOpenModeFlags());
        return var3_5;
    }

    /*
     * WARNING - void declaration
     */
    private static File extractResource(URL resourceAddr) throws IOException {
        URL uRL;
        void var2_3;
        if (resourceAddr.getProtocol().equals("file")) {
            try {
                return new File(resourceAddr.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage());
            }
        }
        String tempFolder = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        String dbFileName = String.format("sqlite-jdbc-tmp-%s.db", UUID.randomUUID());
        File dbFile = new File(tempFolder, (String)var2_3);
        if (dbFile.exists()) {
            long tmpFileLastModified;
            long resourceLastModified = resourceAddr.openConnection().getLastModified();
            if (resourceLastModified < (tmpFileLastModified = dbFile.lastModified())) {
                return dbFile;
            }
            boolean bl = dbFile.delete();
            if (!bl) {
                throw new IOException("failed to remove existing DB file: " + dbFile.getAbsolutePath());
            }
        }
        URLConnection conn = uRL.openConnection();
        conn.setUseCaches(false);
        try (InputStream reader = conn.getInputStream();){
            void var1_2;
            Files.copy(reader, dbFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            void var6_8 = var1_2;
            return var6_8;
        }
    }

    public DB getDatabase() {
        return this.db;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.connectionConfig.isAutoCommit();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAutoCommit(boolean ac) throws SQLException {
        void var1_1;
        this.checkOpen();
        if (this.connectionConfig.isAutoCommit() == ac) {
            return;
        }
        this.connectionConfig.setAutoCommit(ac);
        if (this.getConnectionConfig().isAutoCommit()) {
            this.db.exec("commit;", ac);
            this.currentTransactionMode = null;
            return;
        }
        this.db.exec(this.transactionPrefix(), (boolean)var1_1);
        this.currentTransactionMode = this.getConnectionConfig().getTransactionMode();
    }

    public int getBusyTimeout() {
        return this.db.getConfig().getBusyTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public void setBusyTimeout(int timeoutMillis) throws SQLException {
        void var1_1;
        this.db.getConfig().setBusyTimeout(timeoutMillis);
        this.db.busy_timeout((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setLimit(SQLiteLimits limit, int value) throws SQLException {
        if (value >= 0) {
            void var2_2;
            void var1_1;
            this.db.limit(var1_1.getId(), (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getLimit(SQLiteLimits limit) throws SQLException {
        void var1_1;
        this.db.limit(var1_1.getId(), -1);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.db.isClosed();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.meta != null) {
            this.meta.close();
        }
        this.db.close();
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("database connection closed");
        }
    }

    public String libversion() throws SQLException {
        this.checkOpen();
        return this.db.libversion();
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        if (this.connectionConfig.isAutoCommit()) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("commit;", this.getAutoCommit());
        this.db.exec(this.transactionPrefix(), this.getAutoCommit());
        this.firstStatementExecuted = false;
        SQLiteConnection sQLiteConnection = this;
        sQLiteConnection.setCurrentTransactionMode(sQLiteConnection.getConnectionConfig().getTransactionMode());
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.connectionConfig.isAutoCommit()) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("rollback;", this.getAutoCommit());
        this.db.exec(this.transactionPrefix(), this.getAutoCommit());
        this.firstStatementExecuted = false;
        SQLiteConnection sQLiteConnection = this;
        sQLiteConnection.setCurrentTransactionMode(sQLiteConnection.getConnectionConfig().getTransactionMode());
    }

    /*
     * WARNING - void declaration
     */
    public void addUpdateListener(SQLiteUpdateListener listener) {
        void var1_1;
        this.db.addUpdateListener((SQLiteUpdateListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeUpdateListener(SQLiteUpdateListener listener) {
        void var1_1;
        this.db.removeUpdateListener((SQLiteUpdateListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addCommitListener(SQLiteCommitListener listener) {
        void var1_1;
        this.db.addCommitListener((SQLiteCommitListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeCommitListener(SQLiteCommitListener listener) {
        void var1_1;
        this.db.removeCommitListener((SQLiteCommitListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static String extractPragmasFromFilename(String url, String filename, Properties prop) throws SQLException {
        int parameterDelimiter = filename.indexOf(63);
        if (parameterDelimiter == -1) {
            return filename;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(filename.substring(0, parameterDelimiter));
        int nonPragmaCount = 0;
        String[] parameters = filename.substring(parameterDelimiter + 1).split("&");
        for (int i = 0; i < parameters.length; ++i) {
            void var6_7;
            String parameter = parameters[parameters.length - 1 - i].trim();
            if (parameter.isEmpty()) continue;
            String[] kvp = parameter.split("=");
            String key = kvp[0].trim().toLowerCase();
            if (SQLiteConfig.pragmaSet.contains(key)) {
                if (kvp.length == 1) {
                    throw new SQLException(String.format("Please specify a value for PRAGMA %s in URL %s", key, url));
                }
                String value = kvp[1].trim();
                if (value.isEmpty() || prop.containsKey(key)) continue;
                prop.setProperty(key, value);
                continue;
            }
            sb.append(nonPragmaCount == 0 ? (char)'?' : '&');
            sb.append((String)var6_7);
            ++nonPragmaCount;
        }
        String string = sb.toString();
        return string;
    }

    protected String transactionPrefix() {
        return this.connectionConfig.transactionPrefix();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serialize(String schema) throws SQLException {
        void var1_1;
        return this.db.serialize((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void deserialize(String schema, byte[] buff) throws SQLException {
        void var2_2;
        void var1_1;
        this.db.deserialize((String)var1_1, (byte[])var2_2);
    }
}

