/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.logs;

import app.cash.sqldelight.Query;
import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.db.SqlPreparedStatement;
import app.cash.sqldelight.logs.StatementParameterInterceptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

public final class LogSqliteDriver
implements SqlDriver {
    private final SqlDriver sqlDriver;
    private final Function1<String, Unit> logger;

    /*
     * WARNING - void declaration
     */
    public LogSqliteDriver(SqlDriver sqlDriver, Function1<? super String, Unit> logger) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sqlDriver, (String)"sqlDriver");
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.sqlDriver = var1_1;
        this.logger = var2_2;
    }

    @Override
    public final Transacter.Transaction currentTransaction() {
        return this.sqlDriver.currentTransaction();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final QueryResult<Long> execute(Integer identifier, String sql, int parameters, Function1<? super SqlPreparedStatement, Unit> binders) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.logger.invoke((Object)("EXECUTE\n " + sql));
        this.logParameters(binders);
        return this.sqlDriver.execute((Integer)var1_1, (String)var2_2, (int)var3_3, binders);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <R> QueryResult<R> executeQuery(Integer identifier, String sql, Function1<? super SqlCursor, ? extends QueryResult<R>> mapper, int parameters, Function1<? super SqlPreparedStatement, Unit> binders) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.logger.invoke((Object)("QUERY\n " + sql));
        this.logParameters(binders);
        return this.sqlDriver.executeQuery((Integer)var1_1, (String)var2_2, var3_3, parameters, binders);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final QueryResult<Transacter.Transaction> newTransaction() {
        void var1_1;
        this.logger.invoke((Object)"TRANSACTION BEGIN");
        Transacter.Transaction transaction = this.sqlDriver.newTransaction().getValue();
        transaction.afterCommit((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LogSqliteDriver this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final void invoke() {
                LogSqliteDriver.access$getLogger$p(this.this$0).invoke((Object)"TRANSACTION COMMIT");
            }
        }));
        transaction.afterRollback((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LogSqliteDriver this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final void invoke() {
                LogSqliteDriver.access$getLogger$p(this.this$0).invoke((Object)"TRANSACTION ROLLBACK");
            }
        }));
        return QueryResult.Value.box-impl(QueryResult.Value.constructor-impl(var1_1));
    }

    @Override
    public final void close() {
        this.logger.invoke((Object)"CLOSE CONNECTION");
        this.sqlDriver.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addListener(String[] queryKeys, Query.Listener listener) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.logger.invoke((Object)("BEGIN " + listener + " LISTENING TO [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        void v0 = var1_1;
        this.sqlDriver.addListener((String[])Arrays.copyOf(v0, ((void)v0).length), (Query.Listener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void removeListener(String[] queryKeys, Query.Listener listener) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.logger.invoke((Object)("END " + listener + " LISTENING TO [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        void v0 = var1_1;
        this.sqlDriver.removeListener((String[])Arrays.copyOf(v0, ((void)v0).length), (Query.Listener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void notifyListeners(String ... queryKeys) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        this.logger.invoke((Object)("NOTIFYING LISTENERS OF [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        void v0 = var1_1;
        this.sqlDriver.notifyListeners((String[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    private final void logParameters(Function1<? super SqlPreparedStatement, Unit> binders) {
        Function1<? super SqlPreparedStatement, Unit> function1 = binders;
        if (function1 != null) {
            void var2_2;
            Function1<? super SqlPreparedStatement, Unit> func = function1;
            StatementParameterInterceptor parametersInterceptor = new StatementParameterInterceptor();
            func.invoke((Object)parametersInterceptor);
            List<Object> logParameters = var2_2.getAndClearParameters();
            if (!((Collection)logParameters).isEmpty()) {
                void var1_1;
                this.logger.invoke((Object)(" " + var1_1));
            }
            return;
        }
    }

    public static final /* synthetic */ Function1 access$getLogger$p(LogSqliteDriver $this) {
        return $this.logger;
    }
}

