/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.date;

import io.ktor.util.date.GMTDate;
import io.ktor.util.date.GMTDateBuilder;
import io.ktor.util.date.InvalidDateStringException;
import io.ktor.util.date.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000f\u001a\u00020\u000e*\u00020\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011"}, d2={"Lio/ktor/util/date/GMTDateParser;", "", "", "pattern", "<init>", "(Ljava/lang/String;)V", "dateString", "Lio/ktor/util/date/GMTDate;", "parse", "(Ljava/lang/String;)Lio/ktor/util/date/GMTDate;", "Lio/ktor/util/date/GMTDateBuilder;", "", "type", "chunk", "", "handleToken", "(Lio/ktor/util/date/GMTDateBuilder;CLjava/lang/String;)V", "Ljava/lang/String;", "Companion"})
@SourceDebugExtension(value={"SMAP\nGMTDateParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GMTDateParser.kt\nio/ktor/util/date/GMTDateParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,128:1\n1#2:129\n1069#3,2:130\n*S KotlinDebug\n*F\n+ 1 GMTDateParser.kt\nio/ktor/util/date/GMTDateParser\n*L\n89#1:130,2\n*E\n"})
public final class GMTDateParser {
    public static final Companion Companion = new Companion(null);
    private final String pattern;
    public static final char SECONDS = 's';
    public static final char MINUTES = 'm';
    public static final char HOURS = 'h';
    public static final char DAY_OF_MONTH = 'd';
    public static final char MONTH = 'M';
    public static final char YEAR = 'Y';
    public static final char ZONE = 'z';
    public static final char ANY = '*';

    public GMTDateParser(String pattern) {
        String string;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = string;
        if (!(((CharSequence)this.pattern).length() > 0)) {
            string = "Date parser pattern shouldn't be empty.";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final GMTDate parse(String dateString) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        GMTDateBuilder builder = new GMTDateBuilder();
        int start = 0;
        char current = this.pattern.charAt(0);
        int chunkStart = 0;
        int index = 1;
        try {
            while (index < this.pattern.length()) {
                int n;
                if (this.pattern.charAt(index) == current) {
                    ++index;
                    continue;
                }
                int chunkEnd = chunkStart + index - start;
                String string = dateString.substring(chunkStart, chunkEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.handleToken(builder, current, string);
                chunkStart = n;
                n = index;
                current = this.pattern.charAt(index);
                ++index;
            }
            if (chunkStart < dateString.length()) {
                String string = dateString.substring(chunkStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.handleToken(builder, current, string);
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            throw new InvalidDateStringException((String)var1_1, chunkStart, this.pattern);
        }
        return var2_2.build();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private final void handleToken(GMTDateBuilder $this$handleToken, char type, String chunk) {
        boolean bl;
        block11: {
            void var3_3;
            switch (type) {
                case 's': {
                    ((GMTDateBuilder)$this$handleToken).setSeconds(Integer.parseInt(chunk));
                    return;
                }
                case 'm': {
                    ((GMTDateBuilder)$this$handleToken).setMinutes(Integer.parseInt(chunk));
                    return;
                }
                case 'h': {
                    ((GMTDateBuilder)$this$handleToken).setHours(Integer.parseInt(chunk));
                    return;
                }
                case 'd': {
                    ((GMTDateBuilder)$this$handleToken).setDayOfMonth(Integer.parseInt(chunk));
                    return;
                }
                case 'M': {
                    ((GMTDateBuilder)$this$handleToken).setMonth(Month.Companion.from(chunk));
                    return;
                }
                case 'Y': {
                    ((GMTDateBuilder)$this$handleToken).setYear(Integer.parseInt(chunk));
                    return;
                }
                case 'z': {
                    if (Intrinsics.areEqual((Object)chunk, (Object)"GMT")) return;
                    $this$handleToken = "Check failed.";
                    throw new IllegalStateException($this$handleToken.toString());
                }
                case '*': {
                    return;
                }
            }
            CharSequence $this$all$iv = (CharSequence)var3_3;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char c = $this$all$iv.charAt(i);
                char c2 = c;
                c2 = c;
                if (c == type) continue;
                bl = false;
                break block11;
            }
            bl = true;
        }
        if (bl) return;
        String string = "Check failed.";
        throw new IllegalStateException(string.toString());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006"}, d2={"Lio/ktor/util/date/GMTDateParser$Companion;", "", "<init>", "()V", "", "SECONDS", "C", "MINUTES", "HOURS", "DAY_OF_MONTH", "MONTH", "YEAR", "ZONE", "ANY"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

