/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegateKt;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayoutBuilder;
import androidx.compose.foundation.text.selection.TextSelectionDelegateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.unit.IntSize;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@StabilityInferred(parameters=0)
public final class MultiWidgetSelectionDelegate
implements Selectable {
    private final long selectableId;
    private final Function0<LayoutCoordinates> coordinatesCallback;
    private final Function0<TextLayoutResult> layoutResultCallback;
    private TextLayoutResult _previousTextLayoutResult;
    private int _previousLastVisibleOffset;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public MultiWidgetSelectionDelegate(long selectableId2, Function0<? extends LayoutCoordinates> coordinatesCallback, Function0<TextLayoutResult> layoutResultCallback) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(coordinatesCallback, (String)"coordinatesCallback");
        Intrinsics.checkNotNullParameter(layoutResultCallback, (String)"layoutResultCallback");
        this.selectableId = var1_1;
        this.coordinatesCallback = var3_2;
        this.layoutResultCallback = layoutResultCallback;
        this._previousLastVisibleOffset = -1;
    }

    @Override
    public final long getSelectableId() {
        return this.selectableId;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized int getLastVisibleOffset(TextLayoutResult $this$lastVisibleOffset) {
        if (this._previousTextLayoutResult != $this$lastVisibleOffset) {
            void var1_1;
            void var2_2;
            int n;
            if (!$this$lastVisibleOffset.getDidOverflowHeight() || $this$lastVisibleOffset.getMultiParagraph().getDidExceedMaxLines()) {
                n = $this$lastVisibleOffset.getLineCount() - 1;
            } else {
                int finalVisibleLine;
                TextLayoutResult textLayoutResult = $this$lastVisibleOffset;
                for (finalVisibleLine = RangesKt.coerceAtMost((int)(v190340).getLineForVerticalPosition((float)IntSize.getHeight-impl((long)(v190340).getSize-YbymL2g())), (int)($this$lastVisibleOffset.getLineCount() - 1)); finalVisibleLine >= 0 && $this$lastVisibleOffset.getLineTop(finalVisibleLine) >= (float)IntSize.getHeight-impl((long)$this$lastVisibleOffset.getSize-YbymL2g()); --finalVisibleLine) {
                }
                n = RangesKt.coerceAtLeast((int)finalVisibleLine, (int)0);
            }
            int lastVisibleLine = n;
            this._previousLastVisibleOffset = $this$lastVisibleOffset.getLineEnd((int)var2_2, true);
            this._previousTextLayoutResult = var1_1;
        }
        return this._previousLastVisibleOffset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void appendSelectableInfoToBuilder(SelectionLayoutBuilder builder) {
        void var3_3;
        MultiWidgetSelectionDelegate multiWidgetSelectionDelegate;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return;
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        long relativePosition = builder.getContainerCoordinates().localPositionOf-R5De75A((LayoutCoordinates)var2_2, Offset.Companion.getZero-F1C5BW0());
        long localPosition = Offset.minus-MK-Hz9U((long)builder.getCurrentPosition-F1C5BW0(), (long)relativePosition);
        long localPreviousHandlePosition = OffsetKt.isUnspecified-k-4lQ0M((long)builder.getPreviousHandlePosition-F1C5BW0()) ? Offset.Companion.getUnspecified-F1C5BW0() : Offset.minus-MK-Hz9U((long)builder.getPreviousHandlePosition-F1C5BW0(), (long)relativePosition);
        void v2 = multiWidgetSelectionDelegate;
        multiWidgetSelectionDelegate = this;
        MultiWidgetSelectionDelegateKt.appendSelectableInfo-Parwq6A((SelectionLayoutBuilder)v2, (TextLayoutResult)var3_3, localPosition, localPreviousHandlePosition, multiWidgetSelectionDelegate.selectableId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Selection getSelectAllSelection() {
        void var2_2;
        void var1_1;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int end = textLayoutResult.getLayoutInput().getText().length();
        MultiWidgetSelectionDelegate multiWidgetSelectionDelegate = this;
        multiWidgetSelectionDelegate = this;
        return new Selection(new Selection.AnchorInfo(textLayoutResult2.getBidiRunDirection(0), 0, multiWidgetSelectionDelegate.selectableId), new Selection.AnchorInfo(var1_1.getBidiRunDirection(Math.max(end - 1, 0)), (int)var2_2, multiWidgetSelectionDelegate.selectableId), false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getHandlePosition-dBAh8RU(Selection selection, boolean isStartHandle) {
        void var1_1;
        void var2_2;
        MultiWidgetSelectionDelegate multiWidgetSelectionDelegate;
        block7: {
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
                    if (!isStartHandle) break block5;
                    multiWidgetSelectionDelegate = this;
                    if (selection.getStart().getSelectableId() != multiWidgetSelectionDelegate.selectableId) break block6;
                }
                if (isStartHandle) break block7;
                multiWidgetSelectionDelegate = this;
                if (selection.getEnd().getSelectableId() == multiWidgetSelectionDelegate.selectableId) break block7;
            }
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (this.getLayoutCoordinates() == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int n = isStartHandle ? selection.getStart().getOffset() : selection.getEnd().getOffset();
        int coercedOffset = RangesKt.coerceIn((int)n, (int)0, (int)this.getLastVisibleOffset(textLayoutResult2));
        return TextSelectionDelegateKt.getSelectionHandleCoordinates((TextLayoutResult)multiWidgetSelectionDelegate, coercedOffset, (boolean)var2_2, var1_1.getHandlesCrossed());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LayoutCoordinates getLayoutCoordinates() {
        void var1_1;
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return var1_1;
    }

    @Override
    public final TextLayoutResult textLayoutResult() {
        return (TextLayoutResult)this.layoutResultCallback.invoke();
    }

    @Override
    public final AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", null, null, 6, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult.getLayoutInput().getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Rect getBoundingBox(int offset) {
        void var3_3;
        void var1_1;
        void var2_2;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Rect.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult.getLayoutInput().getText().length();
        if (textLength <= 0) {
            return Rect.Companion.getZero();
        }
        return var2_2.getBoundingBox(RangesKt.coerceIn((int)var1_1, (int)0, (int)(var3_3 - true)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getLastVisibleOffset() {
        void var1_1;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return 0;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return this.getLastVisibleOffset((TextLayoutResult)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getLineHeight(int offset) {
        void var1_1;
        void var2_2;
        void var3_3;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return 0.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult.getLayoutInput().getText().length();
        if (textLength <= 0) {
            return 0.0f;
        }
        int line = textLayoutResult2.getLineForOffset(RangesKt.coerceIn((int)offset, (int)0, (int)(var3_3 - true)));
        return var2_2.getMultiParagraph().getLineHeight((int)var1_1);
    }
}

