/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.TextDragObserver;
import androidx.compose.foundation.text.TextPointerIcon_skikoKt;
import androidx.compose.foundation.text.modifiers.StaticTextSelectionParams;
import androidx.compose.foundation.text.selection.MouseSelectionObserver;
import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegate;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionAdjustment;
import androidx.compose.foundation.text.selection.SelectionGesturesKt;
import androidx.compose.foundation.text.selection.SelectionRegistrar;
import androidx.compose.foundation.text.selection.SelectionRegistrarKt;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.ClipOp;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.input.pointer.PointerIcon;
import androidx.compose.ui.input.pointer.PointerIconKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0015\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001dR\u001a\u0010\u001f\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010#R\u0018\u0010%\u001a\u0004\u0018\u00010$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010'\u0082\u0002\u0004\n\u0002\b!"}, d2={"Landroidx/compose/foundation/text/modifiers/SelectionController;", "Landroidx/compose/runtime/RememberObserver;", "", "selectableId", "Landroidx/compose/foundation/text/selection/SelectionRegistrar;", "selectionRegistrar", "Landroidx/compose/ui/graphics/Color;", "backgroundSelectionColor", "Landroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;", "params", "<init>", "(JLandroidx/compose/foundation/text/selection/SelectionRegistrar;JLandroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "drawScope", "", "draw", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;)V", "onAbandoned", "()V", "onForgotten", "onRemembered", "Landroidx/compose/ui/layout/LayoutCoordinates;", "coordinates", "updateGlobalPosition", "(Landroidx/compose/ui/layout/LayoutCoordinates;)V", "Landroidx/compose/ui/text/TextLayoutResult;", "textLayoutResult", "updateTextLayout", "(Landroidx/compose/ui/text/TextLayoutResult;)V", "J", "Landroidx/compose/ui/Modifier;", "modifier", "Landroidx/compose/ui/Modifier;", "getModifier", "()Landroidx/compose/ui/Modifier;", "Landroidx/compose/foundation/text/modifiers/StaticTextSelectionParams;", "Landroidx/compose/foundation/text/selection/Selectable;", "selectable", "Landroidx/compose/foundation/text/selection/Selectable;", "Landroidx/compose/foundation/text/selection/SelectionRegistrar;"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n+ 2 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n*L\n1#1,359:1\n225#2,8:360\n272#2,14:368\n*S KotlinDebug\n*F\n+ 1 SelectionController.kt\nandroidx/compose/foundation/text/modifiers/SelectionController\n*L\n161#1:360,8\n161#1:368,14\n*E\n"})
public final class SelectionController
implements RememberObserver {
    private final long selectableId;
    private final SelectionRegistrar selectionRegistrar;
    private final long backgroundSelectionColor;
    private StaticTextSelectionParams params;
    private Selectable selectable;
    private final Modifier modifier;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private SelectionController(long selectableId2, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params) {
        TextDragObserver textDragObserver;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)selectionRegistrar, (String)"selectionRegistrar");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.selectableId = var1_1;
        this.selectionRegistrar = textDragObserver;
        this.backgroundSelectionColor = backgroundSelectionColor;
        this.params = params;
        Function0 function0 = (Function0)new Function0<LayoutCoordinates>(this){
            final /* synthetic */ SelectionController this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final LayoutCoordinates invoke() {
                return SelectionController.access$getParams$p(this.this$0).getLayoutCoordinates();
            }
        };
        long l = this.selectableId;
        Object object = this.selectionRegistrar;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"layoutCoordinates");
        long l2 = l;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"layoutCoordinates");
        textDragObserver = new TextDragObserver((Function0<? extends LayoutCoordinates>)function0, (SelectionRegistrar)object, l2){
            private long lastPosition;
            private long dragTotalDistance;
            final /* synthetic */ Function0<LayoutCoordinates> $layoutCoordinates;
            final /* synthetic */ SelectionRegistrar $this_makeDefaultSelectionModifier;
            final /* synthetic */ long $selectableId;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$layoutCoordinates = var1_1;
                this.$this_makeDefaultSelectionModifier = var2_2;
                this.$selectableId = var3_3;
                this.lastPosition = Offset.Companion.getZero-F1C5BW0();
                this.dragTotalDistance = Offset.Companion.getZero-F1C5BW0();
            }

            public final void onDown-k-4lQ0M$1349ef() {
            }

            public final void onUp() {
            }

            /*
             * WARNING - void declaration
             */
            public final void onStart-k-4lQ0M(long startPoint) {
                LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.$layoutCoordinates.invoke();
                if (layoutCoordinates != null) {
                    void var1_1;
                    LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
                    SelectionRegistrar selectionRegistrar = this.$this_makeDefaultSelectionModifier;
                    LayoutCoordinates it = layoutCoordinates2;
                    if (!it.isAttached()) {
                        return;
                    }
                    selectionRegistrar.notifySelectionUpdateStart-ubNVwUQ(layoutCoordinates2, startPoint, SelectionAdjustment.Companion.getWord(), true);
                    this.lastPosition = var1_1;
                }
                if (!SelectionRegistrarKt.hasSelection(this.$this_makeDefaultSelectionModifier, this.$selectableId)) {
                    return;
                }
                this.dragTotalDistance = Offset.Companion.getZero-F1C5BW0();
            }

            /*
             * WARNING - void declaration
             */
            public final void onDrag-k-4lQ0M(long delta) {
                LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.$layoutCoordinates.invoke();
                if (layoutCoordinates != null) {
                    void var1_1;
                    LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
                    SelectionRegistrar selectionRegistrar = this.$this_makeDefaultSelectionModifier;
                    long l = this.$selectableId;
                    LayoutCoordinates it = layoutCoordinates2;
                    if (!it.isAttached()) {
                        return;
                    }
                    if (!SelectionRegistrarKt.hasSelection(selectionRegistrar, l)) {
                        return;
                    }
                    this.dragTotalDistance = Offset.plus-MK-Hz9U((long)this.dragTotalDistance, (long)var1_1);
                    long newPosition = Offset.plus-MK-Hz9U((long)this.lastPosition, (long)this.dragTotalDistance);
                    long l2 = this.lastPosition;
                    SelectionAdjustment selectionAdjustment = SelectionAdjustment.Companion.getWord();
                    boolean bl = selectionRegistrar.notifySelectionUpdate-njBpvok(layoutCoordinates2, newPosition, l2, false, selectionAdjustment, true);
                    if (bl) {
                        this.lastPosition = newPosition;
                        this.dragTotalDistance = Offset.Companion.getZero-F1C5BW0();
                    }
                    return;
                }
            }

            public final void onStop() {
                if (SelectionRegistrarKt.hasSelection(this.$this_makeDefaultSelectionModifier, this.$selectableId)) {
                    this.$this_makeDefaultSelectionModifier.notifySelectionUpdateEnd();
                }
            }

            public final void onCancel() {
                if (SelectionRegistrarKt.hasSelection(this.$this_makeDefaultSelectionModifier, this.$selectableId)) {
                    this.$this_makeDefaultSelectionModifier.notifySelectionUpdateEnd();
                }
            }
        };
        object = new MouseSelectionObserver((Function0<? extends LayoutCoordinates>)function0, (SelectionRegistrar)object, l2){
            private long lastPosition;
            final /* synthetic */ Function0<LayoutCoordinates> $layoutCoordinates;
            final /* synthetic */ SelectionRegistrar $this_makeDefaultSelectionModifier;
            final /* synthetic */ long $selectableId;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$layoutCoordinates = var1_1;
                this.$this_makeDefaultSelectionModifier = var2_2;
                this.$selectableId = var3_3;
                this.lastPosition = Offset.Companion.getZero-F1C5BW0();
            }

            /*
             * WARNING - void declaration
             */
            public final boolean onExtend-k-4lQ0M(long downPosition) {
                LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.$layoutCoordinates.invoke();
                if (layoutCoordinates != null) {
                    SelectionRegistrar selectionRegistrar = this.$this_makeDefaultSelectionModifier;
                    long l = this.$selectableId;
                    LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
                    if (!layoutCoordinates2.isAttached()) {
                        return false;
                    }
                    boolean bl = selectionRegistrar.notifySelectionUpdate-njBpvok(layoutCoordinates, downPosition, this.lastPosition, false, SelectionAdjustment.Companion.getNone(), false);
                    if (bl) {
                        void var1_1;
                        this.lastPosition = var1_1;
                    }
                    return SelectionRegistrarKt.hasSelection(selectionRegistrar, l);
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean onExtendDrag-k-4lQ0M(long dragPosition) {
                block3: {
                    LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.$layoutCoordinates.invoke();
                    if (layoutCoordinates == null) break block3;
                    LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
                    SelectionRegistrar selectionRegistrar = this.$this_makeDefaultSelectionModifier;
                    long l = this.$selectableId;
                    LayoutCoordinates layoutCoordinates3 = layoutCoordinates2;
                    if (!layoutCoordinates3.isAttached()) {
                        return false;
                    }
                    if (!SelectionRegistrarKt.hasSelection(selectionRegistrar, l)) {
                        return false;
                    }
                    boolean bl = selectionRegistrar.notifySelectionUpdate-njBpvok(layoutCoordinates2, dragPosition, this.lastPosition, false, SelectionAdjustment.Companion.getNone(), false);
                    if (bl) {
                        void var1_1;
                        this.lastPosition = var1_1;
                    }
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean onStart-3MmeM6k(long downPosition, SelectionAdjustment adjustment) {
                Intrinsics.checkNotNullParameter((Object)adjustment, (String)"adjustment");
                LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.$layoutCoordinates.invoke();
                if (layoutCoordinates != null) {
                    void var1_1;
                    void var3_2;
                    SelectionRegistrar selectionRegistrar = this.$this_makeDefaultSelectionModifier;
                    long l = this.$selectableId;
                    LayoutCoordinates it = layoutCoordinates;
                    if (!it.isAttached()) {
                        return false;
                    }
                    selectionRegistrar.notifySelectionUpdateStart-ubNVwUQ(it, downPosition, (SelectionAdjustment)var3_2, false);
                    this.lastPosition = var1_1;
                    return SelectionRegistrarKt.hasSelection(selectionRegistrar, l);
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean onDrag-3MmeM6k(long dragPosition, SelectionAdjustment adjustment) {
                block3: {
                    void var3_2;
                    Intrinsics.checkNotNullParameter((Object)adjustment, (String)"adjustment");
                    LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.$layoutCoordinates.invoke();
                    if (layoutCoordinates == null) break block3;
                    LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
                    SelectionRegistrar selectionRegistrar = this.$this_makeDefaultSelectionModifier;
                    long l = this.$selectableId;
                    LayoutCoordinates it = layoutCoordinates2;
                    if (!it.isAttached()) {
                        return false;
                    }
                    if (!SelectionRegistrarKt.hasSelection(selectionRegistrar, l)) {
                        return false;
                    }
                    long l2 = this.lastPosition;
                    boolean bl = selectionRegistrar.notifySelectionUpdate-njBpvok(it, dragPosition, l2, false, (SelectionAdjustment)var3_2, false);
                    if (bl) {
                        void var1_1;
                        this.lastPosition = var1_1;
                    }
                }
                return true;
            }

            public final void onDragDone() {
                this.$this_makeDefaultSelectionModifier.notifySelectionUpdateEnd();
            }
        };
        int n = 2;
        n = 0;
        function0 = TextPointerIcon_skikoKt.getTextPointerIcon();
        Modifier modifier2 = SelectionGesturesKt.selectionGestureInput((Modifier)Modifier.Companion, (MouseSelectionObserver)object, textDragObserver);
        this.modifier = PointerIconKt.pointerHoverIcon((Modifier)modifier2, (PointerIcon)function0, (boolean)false);
    }

    public /* synthetic */ SelectionController(long l, SelectionRegistrar selectionRegistrar, long l2, StaticTextSelectionParams staticTextSelectionParams, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            staticTextSelectionParams = StaticTextSelectionParams.Companion.getEmpty();
        }
        this(l, selectionRegistrar, l2, staticTextSelectionParams, null);
    }

    public final Modifier getModifier() {
        return this.modifier;
    }

    public final void onRemembered() {
        this.selectable = this.selectionRegistrar.subscribe(new MultiWidgetSelectionDelegate(this.selectableId, (Function0<? extends LayoutCoordinates>)((Function0)new Function0<LayoutCoordinates>(this){
            final /* synthetic */ SelectionController this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final LayoutCoordinates invoke() {
                return SelectionController.access$getParams$p(this.this$0).getLayoutCoordinates();
            }
        }), (Function0<TextLayoutResult>)((Function0)new Function0<TextLayoutResult>(this){
            final /* synthetic */ SelectionController this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final TextLayoutResult invoke() {
                return SelectionController.access$getParams$p(this.this$0).getTextLayoutResult();
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    public final void onForgotten() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            void var1_1;
            this.selectionRegistrar.unsubscribe((Selectable)var1_1);
            this.selectable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onAbandoned() {
        Selectable localSelectable = this.selectable;
        if (localSelectable != null) {
            void var1_1;
            this.selectionRegistrar.unsubscribe((Selectable)var1_1);
            this.selectable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTextLayout(TextLayoutResult textLayoutResult) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        TextLayoutResult prevTextLayoutResult = this.params.getTextLayoutResult();
        if (prevTextLayoutResult != null && !Intrinsics.areEqual((Object)var2_2.getLayoutInput().getText(), (Object)textLayoutResult.getLayoutInput().getText())) {
            this.selectionRegistrar.notifySelectableChange(this.selectableId);
        }
        this.params = StaticTextSelectionParams.copy$default(this.params, null, (TextLayoutResult)var1_1, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateGlobalPosition(LayoutCoordinates coordinates) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.params = StaticTextSelectionParams.copy$default(this.params, (LayoutCoordinates)var1_1, null, 2, null);
        this.selectionRegistrar.notifyPositionChange(this.selectableId);
    }

    /*
     * WARNING - void declaration
     */
    public final void draw(DrawScope drawScope) {
        void var1_1;
        int end;
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        Selection selection = (Selection)this.selectionRegistrar.getSubselections().get(this.selectableId);
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        int start = !selection.getHandlesCrossed() ? selection2.getStart().getOffset() : selection2.getEnd().getOffset();
        int n = end = !selection2.getHandlesCrossed() ? selection2.getEnd().getOffset() : selection2.getStart().getOffset();
        if (start == end) {
            return;
        }
        Selectable selectable2 = this.selectable;
        int lastOffset = selectable2 != null ? selectable2.getLastVisibleOffset() : 0;
        int clippedStart = RangesKt.coerceAtMost((int)start, (int)lastOffset);
        int clippedEnd = RangesKt.coerceAtMost((int)end, (int)lastOffset);
        Path path = this.params.getPathForRange(clippedStart, clippedEnd);
        if (path == null) {
            return;
        }
        Path selectionPath = path;
        if (this.params.getShouldClip()) {
            void $this$draw_u24lambda_u241;
            void $this$clipRect_u2drOu3jXo_u24default$iv = $this$draw_u24lambda_u241;
            float right$iv = Size.getWidth-impl((long)$this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc());
            float bottom$iv = Size.getHeight-impl((long)$this$clipRect_u2drOu3jXo_u24default$iv.getSize-NH-jbRc());
            int clipOp$iv = ClipOp.Companion.getIntersect-rtfAjoo();
            void $this$withTransform$iv$iv = $this$clipRect_u2drOu3jXo_u24default$iv;
            DrawContext $this$withTransform_u24lambda_u246$iv$iv = $this$withTransform$iv$iv.getDrawContext();
            long previousSize$iv$iv = $this$withTransform_u24lambda_u246$iv$iv.getSize-NH-jbRc();
            $this$withTransform_u24lambda_u246$iv$iv.getCanvas().save();
            try {
                void var3_7;
                DrawTransform drawTransform = $this$withTransform_u24lambda_u246$iv$iv.getTransform();
                drawTransform.clipRect-N_I0leg(0.0f, 0.0f, (float)var3_7, bottom$iv, clipOp$iv);
                DrawScope.drawPath-LG529CI$default((DrawScope)var1_1, (Path)selectionPath, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
            }
            finally {
                $this$withTransform_u24lambda_u246$iv$iv.getCanvas().restore();
                $this$withTransform_u24lambda_u246$iv$iv.setSize-uvyYCjk(previousSize$iv$iv);
            }
        } else {
            void var2_5;
            DrawScope.drawPath-LG529CI$default((DrawScope)var1_1, (Path)var2_5, (long)this.backgroundSelectionColor, (float)0.0f, null, null, (int)0, (int)60, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ SelectionController(long selectableId2, SelectionRegistrar selectionRegistrar, long backgroundSelectionColor, StaticTextSelectionParams params, DefaultConstructorMarker $constructor_marker) {
        this((long)var1_1, (SelectionRegistrar)var3_2, backgroundSelectionColor, params);
        void var3_2;
        void var1_1;
    }

    public static final /* synthetic */ StaticTextSelectionParams access$getParams$p(SelectionController $this) {
        return $this.params;
    }
}

