/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.LazyLayoutItemProviderKt;
import androidx.compose.foundation.lazy.layout.LazyLayoutNearestRangeState;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PagerLazyLayoutItemProvider;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dR+\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00028F@BX\u0087\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\rR+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00048F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010\u0019R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0018\u0010,\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0017\u0010/\u001a\u00020.8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0011\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\u0006\n\u0004\b\u0007\u00103"}, d2={"Landroidx/compose/foundation/pager/PagerScrollPosition;", "", "", "currentPage", "", "currentPageOffsetFraction", "Landroidx/compose/foundation/pager/PagerState;", "state", "<init>", "(IFLandroidx/compose/foundation/pager/PagerState;)V", "delta", "", "applyScrollDelta", "(I)V", "Landroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;", "itemProvider", "index", "matchPageWithKey", "(Landroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;I)I", "offsetFraction", "requestPositionAndForgetLastKnownKey", "(IF)V", "page", "update", "updateCurrentPageOffsetFraction", "(F)V", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "measureResult", "updateFromMeasureResult", "(Landroidx/compose/foundation/pager/PagerMeasureResult;)V", "<set-?>", "currentPage$delegate", "Landroidx/compose/runtime/MutableIntState;", "getCurrentPage", "()I", "setCurrentPage", "currentPageOffsetFraction$delegate", "Landroidx/compose/runtime/MutableFloatState;", "getCurrentPageOffsetFraction", "()F", "setCurrentPageOffsetFraction", "", "hadFirstNotEmptyLayout", "Z", "lastKnownCurrentPageKey", "Ljava/lang/Object;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "nearestRangeState", "Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "getNearestRangeState", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "Landroidx/compose/foundation/pager/PagerState;"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPagerScrollPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n+ 2 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 3 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n+ 4 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPositionKt\n*L\n1#1,152:1\n78#2:153\n111#2,2:154\n79#3:156\n112#3,2:157\n142#4,4:159\n*S KotlinDebug\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n*L\n44#1:153\n44#1:154,2\n47#1:156\n47#1:157,2\n120#1:159,4\n*E\n"})
public final class PagerScrollPosition {
    public final PagerState state;
    private final MutableIntState currentPage$delegate;
    private final MutableFloatState currentPageOffsetFraction$delegate;
    private boolean hadFirstNotEmptyLayout;
    private Object lastKnownCurrentPageKey;
    private final LazyLayoutNearestRangeState nearestRangeState;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PagerScrollPosition(int currentPage, float currentPageOffsetFraction, PagerState state) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = var3_3;
        this.currentPage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)currentPage);
        this.currentPageOffsetFraction$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf((float)var2_2);
        this.nearestRangeState = new LazyLayoutNearestRangeState((int)var1_1, 30, 100);
    }

    public final int getCurrentPage() {
        IntState intState = (IntState)this.currentPage$delegate;
        return intState.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentPage(int n) {
        void var1_1;
        MutableIntState mutableIntState = this.currentPage$delegate;
        mutableIntState.setIntValue((int)var1_1);
    }

    public final float getCurrentPageOffsetFraction() {
        FloatState floatState = (FloatState)this.currentPageOffsetFraction$delegate;
        return floatState.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentPageOffsetFraction(float f) {
        void var1_1;
        MutableFloatState mutableFloatState = this.currentPageOffsetFraction$delegate;
        mutableFloatState.setFloatValue((float)var1_1);
    }

    public final LazyLayoutNearestRangeState getNearestRangeState() {
        return this.nearestRangeState;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateFromMeasureResult(PagerMeasureResult measureResult2) {
        Intrinsics.checkNotNullParameter((Object)measureResult2, (String)"measureResult");
        MeasuredPage measuredPage = measureResult2.getCurrentPage();
        Object object = this.lastKnownCurrentPageKey = measuredPage != null ? measuredPage.getKey() : null;
        if (this.hadFirstNotEmptyLayout || !((Collection)measureResult2.getVisiblePagesInfo()).isEmpty()) {
            void var1_1;
            this.hadFirstNotEmptyLayout = true;
            MeasuredPage measuredPage2 = measureResult2.getCurrentPage();
            this.update(measuredPage2 != null ? measuredPage2.getIndex() : 0, var1_1.getCurrentPageOffsetFraction());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void requestPositionAndForgetLastKnownKey(int index, float offsetFraction) {
        void var2_2;
        void var1_1;
        this.update((int)var1_1, (float)var2_2);
        this.lastKnownCurrentPageKey = null;
    }

    /*
     * WARNING - void declaration
     */
    public final int matchPageWithKey(PagerLazyLayoutItemProvider itemProvider, int index) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)itemProvider, (String)"itemProvider");
        int newIndex = LazyLayoutItemProviderKt.findIndexByKey(itemProvider, this.lastKnownCurrentPageKey, index);
        if (index != newIndex) {
            void var2_3;
            this.setCurrentPage(newIndex);
            this.nearestRangeState.update((int)var2_3);
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final void update(int page, float offsetFraction) {
        void var2_2;
        void var1_1;
        this.setCurrentPage(page);
        this.nearestRangeState.update((int)var1_1);
        this.setCurrentPageOffsetFraction((float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCurrentPageOffsetFraction(float offsetFraction) {
        void var1_1;
        this.setCurrentPageOffsetFraction((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void applyScrollDelta(int $i$f$debugLog) {
        void var1_2;
        float fractionUpdate = this.state.getPageSizeWithSpacing$foundation() == 0 ? 0.0f : (float)$i$f$debugLog / (float)this.state.getPageSizeWithSpacing$foundation();
        PagerScrollPosition pagerScrollPosition = this;
        pagerScrollPosition.setCurrentPageOffsetFraction(pagerScrollPosition.getCurrentPageOffsetFraction() + var1_2);
    }
}

