/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.CoreKt;
import kotlinx.io.PeekSource;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io._UtilKt;

@SourceDebugExtension(value={"SMAP\nRealSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealSource.kt\nkotlinx/io/RealSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,162:1\n159#1:163\n160#1:165\n159#1:167\n160#1:169\n159#1:170\n160#1:172\n159#1:176\n160#1:178\n159#1:180\n160#1:182\n1#2:164\n1#2:166\n1#2:168\n1#2:171\n1#2:173\n1#2:177\n1#2:179\n1#2:181\n1#2:183\n38#3:174\n112#3:175\n*S KotlinDebug\n*F\n+ 1 RealSource.kt\nkotlinx/io/RealSource\n*L\n38#1:163\n38#1:165\n51#1:167\n51#1:169\n60#1:170\n60#1:172\n127#1:176\n127#1:178\n144#1:180\n144#1:182\n38#1:164\n51#1:168\n60#1:171\n127#1:177\n144#1:181\n74#1:174\n80#1:175\n*E\n"})
public final class RealSource
implements Source {
    private final RawSource source;
    @JvmField
    public boolean closed;
    private final Buffer bufferField;

    /*
     * WARNING - void declaration
     */
    public RealSource(RawSource source) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = var1_1;
        this.bufferField = new Buffer();
    }

    @Override
    public final Buffer getBuffer() {
        return this.bufferField;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long readAtMostTo(Buffer sink, long byteCount) {
        void var1_1;
        void var2_2;
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        RealSource realSource = this;
        if (!(!realSource.closed)) {
            sink = "Source is closed.";
            throw new IllegalStateException(sink.toString());
        }
        if (!(byteCount >= 0L)) {
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.bufferField.getSize() == 0L && (l = this.source.readAtMostTo(this.bufferField, 8192L)) == -1L) {
            return -1L;
        }
        long toRead = Math.min((long)var2_2, this.bufferField.getSize());
        return this.bufferField.readAtMostTo((Buffer)var1_1, toRead);
    }

    @Override
    public final boolean exhausted() {
        Object object = this;
        if (!(!((RealSource)object).closed)) {
            object = "Source is closed.";
            throw new IllegalStateException(object.toString());
        }
        return this.bufferField.exhausted() && this.source.readAtMostTo(this.bufferField, 8192L) == -1L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void require(long byteCount) {
        if (!this.request(byteCount)) {
            void var1_1;
            throw new EOFException("Source doesn't contain required number of bytes (" + (long)var1_1 + ").");
        }
    }

    @Override
    public final boolean request(long byteCount22) {
        long byteCount22;
        RealSource realSource = this;
        if (!(!realSource.closed)) {
            String byteCount22 = "Source is closed.";
            throw new IllegalStateException(byteCount22.toString());
        }
        if (!(byteCount22 >= 0L)) {
            String byteCount22 = "byteCount: " + byteCount22;
            throw new IllegalArgumentException(byteCount22.toString());
        }
        while (this.bufferField.getSize() < byteCount22) {
            if (this.source.readAtMostTo(this.bufferField, 8192L) != -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public final byte readByte() {
        this.require(1L);
        return this.bufferField.readByte();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readAtMostTo(byte[] sink, int startIndex, int endIndex) {
        void var1_1;
        void var2_2;
        void a$iv;
        void var3_3;
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int n = sink.length;
        _UtilKt.checkBounds(n, startIndex, endIndex);
        if (this.bufferField.getSize() == 0L && (l = this.source.readAtMostTo(this.bufferField, 8192L)) == -1L) {
            return -1;
        }
        void var5_6 = var3_3 - startIndex;
        long b$iv = this.bufferField.getSize();
        int toRead = (int)Math.min((long)a$iv, b$iv);
        void v0 = var2_2;
        return this.bufferField.readAtMostTo((byte[])var1_1, (int)v0, (int)(v0 + toRead));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readTo(RawSink sink, long byteCount) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        try {
            this.require(byteCount);
        }
        catch (EOFException e) {
            void var2_3;
            sink.write(this.bufferField, this.bufferField.getSize());
            throw var2_3;
        }
        this.bufferField.readTo((RawSink)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long transferTo(RawSink sink) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long totalBytesWritten = 0L;
        while (this.source.readAtMostTo(this.bufferField, 8192L) != -1L) {
            long emitByteCount = this.bufferField.completeSegmentByteCount$kotlinx_io_core();
            if (emitByteCount <= 0L) continue;
            totalBytesWritten += emitByteCount;
            sink.write(this.bufferField, emitByteCount);
        }
        if (this.bufferField.getSize() > 0L) {
            void var1_1;
            totalBytesWritten += this.bufferField.getSize();
            var1_1.write(this.bufferField, this.bufferField.getSize());
        }
        return (long)var2_2;
    }

    @Override
    public final short readShort() {
        this.require(2L);
        return this.bufferField.readShort();
    }

    @Override
    public final int readInt() {
        this.require(4L);
        return this.bufferField.readInt();
    }

    @Override
    public final long readLong() {
        this.require(8L);
        return this.bufferField.readLong();
    }

    @Override
    public final Source peek() {
        Object object = this;
        if (!(!((RealSource)object).closed)) {
            object = "Source is closed.";
            throw new IllegalStateException(object.toString());
        }
        return CoreKt.buffered(new PeekSource(this));
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.bufferField.clear();
    }

    public final String toString() {
        return "buffered(" + this.source + ')';
    }
}

