/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.nio.ByteBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;

@SourceDebugExtension(value={"SMAP\nBuffersJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuffersJvm.kt\nkotlinx/io/BuffersJvmKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 5 Buffer.kt\nkotlinx/io/BufferKt\n+ 6 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperationsKt\n*L\n1#1,207:1\n52#2:208\n53#2:210\n109#2:217\n109#2:242\n112#2:260\n1#3:209\n1#3:239\n1#3:250\n1#3:286\n195#4,6:211\n203#4,20:218\n99#4:238\n100#4,2:240\n102#4,6:243\n347#4:249\n348#4,5:251\n353#4:258\n354#4:262\n355#4:284\n99#4:285\n100#4,8:287\n195#4,28:295\n651#5,2:256\n655#5,21:263\n434#6:259\n435#6:261\n*S KotlinDebug\n*F\n+ 1 BuffersJvm.kt\nkotlinx/io/BuffersJvmKt\n*L\n57#1:208\n57#1:210\n68#1:217\n101#1:242\n138#1:260\n57#1:209\n100#1:239\n133#1:250\n160#1:286\n67#1:211,6\n67#1:218,20\n100#1:238\n100#1:240,2\n100#1:243,6\n133#1:249\n133#1:251,5\n133#1:258\n133#1:262\n133#1:284\n160#1:285\n160#1:287,8\n180#1:295,28\n133#1:256,2\n133#1:263,21\n137#1:259\n137#1:261\n*E\n"})
public final class BuffersJvmKt {
    /*
     * WARNING - void declaration
     */
    public static final int readAtMostTo(Buffer $this$readAtMostTo, ByteBuffer sink) {
        void var1_1;
        void pos;
        void limit;
        Intrinsics.checkNotNullParameter((Object)$this$readAtMostTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (((Buffer)$this$readAtMostTo).exhausted()) {
            return -1;
        }
        if (!(!((Buffer)$this$readAtMostTo).exhausted())) {
            $this$readAtMostTo = "Buffer is empty";
            throw new IllegalArgumentException($this$readAtMostTo.toString());
        }
        Segment segment = ((Buffer)$this$readAtMostTo).getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment head$iv = segment;
        int n = head$iv.getLimit();
        int n2 = head$iv.getPos();
        byte[] data = segment.dataAsByteArray$25d3abe();
        int toCopy = Math.min(sink.remaining(), (int)(limit - pos));
        var1_1.put(data, (int)pos, toCopy);
        if (toCopy != 0) {
            Buffer buffer;
            void var3_2;
            if (toCopy < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (toCopy > var3_2.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer.skip(toCopy);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final Buffer transferFrom(Buffer $this$transferFrom, ByteBuffer source) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)$this$transferFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int remaining = source.remaining();
        while (remaining > 0) {
            void var3_3;
            void pos;
            void limit;
            Segment tail$iv = ((Buffer)$this$transferFrom).writableSegment(1);
            byte[] data$iv = tail$iv.dataAsByteArray$25d3abe();
            int n = data$iv.length;
            int n2 = tail$iv.getLimit();
            byte[] data = data$iv;
            int toCopy = Math.min(remaining, (int)(limit - pos));
            source.get(data, (int)pos, toCopy);
            remaining -= toCopy;
            int bytesWritten$iv = toCopy;
            if (bytesWritten$iv == 1) {
                Segment.writeBackData$49634b87(data$iv);
                Segment segment = tail$iv;
                segment.setLimit(segment.getLimit() + bytesWritten$iv);
                Buffer buffer2 = $this$transferFrom;
                buffer2.setSizeMut(buffer2.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!(bytesWritten$iv >= 0 ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                $this$transferFrom = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException($this$transferFrom.toString());
            }
            if (bytesWritten$iv != 0) {
                Segment.writeBackData$49634b87(data$iv);
                Segment segment = tail$iv;
                segment.setLimit(segment.getLimit() + bytesWritten$iv);
                Buffer buffer3 = $this$transferFrom;
                buffer3.setSizeMut(buffer3.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!SegmentKt.isEmpty((Segment)var3_3)) continue;
            ((Buffer)$this$transferFrom).recycleTail();
        }
        return buffer;
    }
}

