/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;

@SourceDebugExtension(value={"SMAP\nStringJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringJsonLexer.kt\nkotlinx/serialization/json/internal/StringJsonLexer\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n158#2:130\n158#2:131\n158#2:132\n158#2:133\n1863#3,2:134\n*S KotlinDebug\n*F\n+ 1 StringJsonLexer.kt\nkotlinx/serialization/json/internal/StringJsonLexer\n*L\n23#1:130\n38#1:131\n57#1:132\n73#1:133\n109#1:134,2\n*E\n"})
public class StringJsonLexer
extends AbstractJsonLexer {
    private final String source;

    /*
     * WARNING - void declaration
     */
    public StringJsonLexer(String source) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = var1_1;
    }

    @Override
    protected final String getSource() {
        return this.source;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int prefetchOrEof(int position) {
        StringJsonLexer stringJsonLexer = this;
        if (position < stringJsonLexer.source.length()) {
            void var1_1;
            return (int)var1_1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte consumeNextToken() {
        StringJsonLexer stringJsonLexer = this;
        String source = stringJsonLexer.source;
        int cpos = this.currentPosition;
        while (cpos != -1 && cpos < source.length()) {
            void var3_3;
            void var2_2;
            char c = source.charAt(cpos++);
            char $this$isWs$iv = c;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') continue;
            this.currentPosition = var2_2;
            return AbstractJsonLexerKt.charToTokenClass((char)var3_3);
        }
        this.currentPosition = ((String)((Object)stringJsonLexer)).length();
        return 10;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canConsumeValue() {
        void var1_1;
        int current = this.currentPosition;
        if (current == -1) {
            return false;
        }
        StringJsonLexer stringJsonLexer = this;
        String source = stringJsonLexer.source;
        while (current < source.length()) {
            void var3_3;
            char c = source.charAt(current);
            char $this$isWs$iv = c;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return StringJsonLexer.isValidValueStart((char)var3_3);
        }
        this.currentPosition = var1_1;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int skipWhitespaces() {
        void var1_1;
        int current = this.currentPosition;
        if (current == -1) {
            return current;
        }
        StringJsonLexer stringJsonLexer = this;
        String source = stringJsonLexer.source;
        while (current < source.length()) {
            void var3_3;
            char c = source.charAt(current);
            char $this$isWs$iv = c;
            if (!($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || var3_3 == 9)) break;
            ++current;
        }
        this.currentPosition = current;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void consumeNextToken(char expected) {
        void var1_1;
        if (this.currentPosition == -1) {
            this.unexpectedToken(expected);
        }
        StringJsonLexer stringJsonLexer = this;
        String source = stringJsonLexer.source;
        int cpos = this.currentPosition;
        while (cpos < source.length()) {
            char c = source.charAt(cpos++);
            char $this$isWs$iv = c;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') continue;
            this.currentPosition = cpos;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.currentPosition = -1;
        this.unexpectedToken((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String consumeKeyString() {
        void var2_3;
        void var1_1;
        ((AbstractJsonLexer)this).consumeNextToken('\"');
        int current = this.currentPosition;
        StringJsonLexer stringJsonLexer = this;
        int closingQuote = StringsKt.indexOf$default((CharSequence)stringJsonLexer.source, (char)'\"', (int)current, (boolean)false, (int)4, null);
        if (closingQuote == -1) {
            this.consumeStringLenient();
            this.fail$kotlinx_serialization_json((byte)1, false);
            throw new KotlinNothingValueException();
        }
        for (int i = current; i < closingQuote; ++i) {
            stringJsonLexer = this;
            if (stringJsonLexer.source.charAt(i) != '\\') continue;
            stringJsonLexer = this;
            return stringJsonLexer.consumeString(stringJsonLexer.source, this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        stringJsonLexer = this;
        String string = stringJsonLexer.source.substring((int)var1_1, (int)var2_3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String peekLeadingMatchingValue(String keyToMatch, boolean isLenient) {
        void var2_3;
        String string;
        int positionSnapshot;
        block7: {
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)keyToMatch, (String)"keyToMatch");
                    positionSnapshot = this.currentPosition;
                    try {
                        if (((AbstractJsonLexer)this).consumeNextToken() == 6) break block5;
                        this.currentPosition = positionSnapshot;
                        this.discardPeeked();
                        return null;
                    }
                    catch (Throwable throwable) {
                        void var3_4;
                        this.currentPosition = var3_4;
                        this.discardPeeked();
                        throw throwable;
                    }
                }
                String string2 = this.peekString(isLenient);
                if (Intrinsics.areEqual((Object)string2, (Object)string)) break block6;
                this.currentPosition = positionSnapshot;
                this.discardPeeked();
                return null;
            }
            this.discardPeeked();
            if (((AbstractJsonLexer)this).consumeNextToken() == 5) break block7;
            this.currentPosition = positionSnapshot;
            this.discardPeeked();
            return null;
        }
        string = this.peekString((boolean)var2_3);
        this.currentPosition = positionSnapshot;
        this.discardPeeked();
        return string;
    }
}

