/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.internal.Composer;
import kotlinx.serialization.json.internal.ComposerForUnquotedLiterals;
import kotlinx.serialization.json.internal.ComposerForUnsignedNumbers;
import kotlinx.serialization.json.internal.ComposerWithPrettyPrint;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;

@SourceDebugExtension(value={"SMAP\nStreamingJsonEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingJsonEncoder.kt\nkotlinx/serialization/json/internal/StreamingJsonEncoder\n+ 2 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n178#1,2:259\n178#1,2:261\n21#2,12:233\n35#2,13:246\n1#3:245\n1#3:263\n*S KotlinDebug\n*F\n+ 1 StreamingJsonEncoder.kt\nkotlinx/serialization/json/internal/StreamingJsonEncoder\n*L\n168#1:259,2\n169#1:261,2\n68#1:233,12\n68#1:246,13\n68#1:245\n*E\n"})
public final class StreamingJsonEncoder
extends AbstractEncoder
implements JsonEncoder {
    private final Composer composer;
    private final Json json;
    private final WriteMode mode;
    private final JsonEncoder[] modeReuseCache;
    private final SerializersModule serializersModule;
    private final JsonConfiguration configuration;
    private boolean forceQuoting;
    private String polymorphicDiscriminator;
    private String polymorphicSerialName;

    /*
     * WARNING - void declaration
     */
    private StreamingJsonEncoder(Composer composer, Json json, WriteMode mode, JsonEncoder[] modeReuseCache) {
        void var3_4;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.composer = composer;
        this.json = var2_3;
        this.mode = var3_4;
        this.modeReuseCache = modeReuseCache;
        composer = this;
        ((StreamingJsonEncoder)composer).serializersModule = ((StreamingJsonEncoder)composer).json.getSerializersModule();
        composer = this;
        ((StreamingJsonEncoder)composer).configuration = ((StreamingJsonEncoder)composer).json.getConfiguration();
        int i = this.mode.ordinal();
        if (this.modeReuseCache != null && (this.modeReuseCache[i] != null || this.modeReuseCache[i] != this)) {
            this.modeReuseCache[var1_2] = this;
        }
    }

    @Override
    public final Json getJson() {
        return this.json;
    }

    /*
     * WARNING - void declaration
     */
    public StreamingJsonEncoder(InternalJsonWriter output, Json json, WriteMode mode, JsonEncoder[] modeReuseCache) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)modeReuseCache, (String)"modeReuseCache");
        Json json2 = json;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sb");
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        this(json2.getConfiguration().getPrettyPrint() ? (Composer)new ComposerWithPrettyPrint((InternalJsonWriter)var1_1, json2) : new Composer((InternalJsonWriter)var1_1), (Json)var2_2, (WriteMode)var3_3, modeReuseCache);
    }

    public final SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public final boolean shouldEncodeElementDefault(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.configuration.getEncodeDefaults();
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void encodeSerializableValue(SerializationStrategy<? super T> serializer, T value) {
        void var2_2;
        void var3_3;
        void var1_1;
        void actualSerializer$iv;
        SerializationStrategy serializationStrategy;
        String baseClassDiscriminator$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        JsonEncoder $this$encodePolymorphically$iv = this;
        if ($this$encodePolymorphically$iv.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer.serialize((Encoder)$this$encodePolymorphically$iv, value);
            return;
        }
        boolean isPolymorphicSerializer$iv = serializer instanceof AbstractPolymorphicSerializer;
        if (isPolymorphicSerializer$iv) {
            bl = $this$encodePolymorphically$iv.getJson().getConfiguration().getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
        } else {
            switch (PolymorphicKt.WhenMappings.$EnumSwitchMapping$0[$this$encodePolymorphically$iv.getJson().getConfiguration().getClassDiscriminatorMode().ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    SerialKind it$iv2 = serializer.getDescriptor().getKind();
                    if (Intrinsics.areEqual((Object)it$iv2, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)it$iv2, (Object)StructureKind.OBJECT.INSTANCE)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        boolean it$iv2 = bl;
        String string = baseClassDiscriminator$iv = bl ? PolymorphicKt.classDiscriminator(serializer.getDescriptor(), $this$encodePolymorphically$iv.getJson()) : null;
        if (isPolymorphicSerializer$iv) {
            AbstractPolymorphicSerializer casted$iv = (AbstractPolymorphicSerializer)serializer;
            if (value == null) {
                String it$iv2 = "Value for serializer " + ((AbstractPolymorphicSerializer)serializer).getDescriptor() + " should always be non-null. Please report issue to the kotlinx.serialization tracker.";
                throw new IllegalArgumentException(it$iv2.toString());
            }
            SerializationStrategy actual$iv = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)casted$iv, (Encoder)$this$encodePolymorphically$iv, value);
            if (baseClassDiscriminator$iv != null) {
                PolymorphicKt.access$validateIfSealed(serializer, actual$iv, baseClassDiscriminator$iv);
            }
            serializer = actual$iv.getDescriptor().getKind();
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"kind");
            if (serializer instanceof SerialKind.ENUM) {
                throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
            }
            if (serializer instanceof PrimitiveKind) {
                throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
            }
            if (serializer instanceof PolymorphicKind) {
                throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself".toString());
            }
            Intrinsics.checkNotNull((Object)actual$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.SerializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.encodePolymorphically>");
            serializationStrategy = actual$iv;
        } else {
            serializationStrategy = actualSerializer$iv = actualSerializer$iv;
        }
        if (baseClassDiscriminator$iv != null) {
            void serialName;
            String discriminatorName;
            String casted$iv = actualSerializer$iv.getDescriptor().getSerialName();
            this.polymorphicDiscriminator = discriminatorName = baseClassDiscriminator$iv;
            this.polymorphicSerialName = serialName;
        }
        var1_1.serialize((Encoder)var3_3, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final CompositeEncoder beginStructure(SerialDescriptor descriptor) {
        void var2_3;
        String discriminator;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        StreamingJsonEncoder streamingJsonEncoder = this;
        WriteMode newMode = WriteModeKt.switchMode(streamingJsonEncoder.json, descriptor);
        if (newMode.begin != '\u0000') {
            this.composer.print(newMode.begin);
            this.composer.indent();
        }
        if ((discriminator = this.polymorphicDiscriminator) != null) {
            StreamingJsonEncoder streamingJsonEncoder2;
            String string = this.polymorphicSerialName;
            if (string == null) {
                string = streamingJsonEncoder2.getSerialName();
            }
            String string2 = string;
            streamingJsonEncoder2 = this;
            streamingJsonEncoder2.composer.nextItem();
            streamingJsonEncoder2.encodeString((String)((Object)streamingJsonEncoder));
            streamingJsonEncoder2.composer.print(':');
            streamingJsonEncoder2.composer.space();
            streamingJsonEncoder2.encodeString(string2);
            this.polymorphicDiscriminator = null;
            this.polymorphicSerialName = null;
        }
        if (this.mode == newMode) {
            return this;
        }
        Object object = this.modeReuseCache;
        if (this.modeReuseCache != null && (object = object[newMode.ordinal()]) != null) {
            return (CompositeEncoder)object;
        }
        streamingJsonEncoder = this;
        return new StreamingJsonEncoder(this.composer, streamingJsonEncoder.json, (WriteMode)var2_3, this.modeReuseCache);
    }

    public final void endStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.mode.end != '\u0000') {
            this.composer.unIndent();
            this.composer.nextItemIfNotFirst();
            this.composer.print(this.mode.end);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean encodeElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                break;
            }
            case 2: {
                if (!this.composer.getWritingFirst()) {
                    boolean bl;
                    if (index % 2 == 0) {
                        this.composer.print(',');
                        this.composer.nextItem();
                        bl = true;
                    } else {
                        this.composer.print(':');
                        this.composer.space();
                        bl = false;
                    }
                    this.forceQuoting = bl;
                    break;
                }
                this.forceQuoting = true;
                this.composer.nextItem();
                break;
            }
            case 3: {
                if (index == 0) {
                    this.forceQuoting = true;
                }
                if (index != 1) break;
                this.composer.print(',');
                this.composer.space();
                this.forceQuoting = false;
                break;
            }
            default: {
                void var2_2;
                StreamingJsonEncoder streamingJsonEncoder;
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                void v1 = streamingJsonEncoder;
                streamingJsonEncoder = this;
                this.encodeString(JsonNamesMapKt.getJsonElementName((SerialDescriptor)v1, streamingJsonEncoder.json, (int)var2_2));
                this.composer.print(':');
                this.composer.space();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void encodeNullableSerializableElement(SerialDescriptor descriptor, int index, SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        if (value != null || this.configuration.getExplicitNulls()) {
            void var3_3;
            void var2_2;
            void var1_1;
            super.encodeNullableSerializableElement((SerialDescriptor)var1_1, (int)var2_2, (SerializationStrategy)var3_3, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Encoder encodeInline(SerialDescriptor descriptor) {
        Object object;
        Object p12;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (StreamingJsonEncoderKt.isUnsignedNumber(descriptor)) {
            Object p0;
            Composer composer;
            StreamingJsonEncoder this_$iv = this;
            if (this_$iv.composer instanceof ComposerForUnsignedNumbers) {
                composer = this_$iv.composer;
            } else {
                boolean p12 = this_$iv.forceQuoting;
                p0 = this_$iv.composer.writer;
                composer = new ComposerForUnsignedNumbers((InternalJsonWriter)p0, p12);
            }
            StreamingJsonEncoder streamingJsonEncoder = this;
            p12 = streamingJsonEncoder;
            p12 = this.mode;
            p0 = streamingJsonEncoder.json;
            Composer composer2 = composer;
            return new StreamingJsonEncoder(composer2, (Json)p0, (WriteMode)((Object)p12), null);
        }
        if (StreamingJsonEncoderKt.isUnquotedLiteral((SerialDescriptor)p12)) {
            Json json;
            Composer composer;
            StreamingJsonEncoder this_$iv = this;
            if (this_$iv.composer instanceof ComposerForUnquotedLiterals) {
                composer = this_$iv.composer;
            } else {
                void var1_3;
                boolean p13 = this_$iv.forceQuoting;
                InternalJsonWriter p0 = this_$iv.composer.writer;
                composer = new ComposerForUnquotedLiterals((InternalJsonWriter)((Object)json), (boolean)var1_3);
            }
            StreamingJsonEncoder streamingJsonEncoder = this;
            object = streamingJsonEncoder;
            object = this.mode;
            json = streamingJsonEncoder.json;
            Composer composer3 = composer;
            return new StreamingJsonEncoder(composer3, json, (WriteMode)((Object)object), null);
        }
        if (this.polymorphicDiscriminator != null) {
            StreamingJsonEncoder streamingJsonEncoder;
            StreamingJsonEncoder streamingJsonEncoder2 = streamingJsonEncoder = this;
            streamingJsonEncoder.polymorphicSerialName = object.getSerialName();
            return streamingJsonEncoder;
        }
        return super.encodeInline((SerialDescriptor)object);
    }

    public final void encodeNull() {
        this.composer.print("null");
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeBoolean(boolean value) {
        void var1_1;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
            return;
        }
        void var2_3 = var1_1;
        Composer composer = this.composer;
        composer.writer.write(String.valueOf((boolean)var2_3));
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeByte(byte value) {
        void var1_1;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
            return;
        }
        this.composer.print((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeShort(short value) {
        void var1_1;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
            return;
        }
        this.composer.print((short)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeInt(int value) {
        void var1_1;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
            return;
        }
        this.composer.print((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeLong(long value) {
        void var1_1;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
            return;
        }
        this.composer.print((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeFloat(float value) {
        float f;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            float f2 = value;
            Composer composer = this.composer;
            composer.writer.write(String.valueOf(f2));
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Float.isInfinite(f = value) && !Float.isNaN(f))) {
            void var1_1;
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(Float.valueOf((float)var1_1), this.composer.writer.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeDouble(double value) {
        double d;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            double d2 = value;
            Composer composer = this.composer;
            composer.writer.write(String.valueOf(d2));
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Double.isInfinite(d = value) && !Double.isNaN(d))) {
            void var1_1;
            throw JsonExceptionsKt.InvalidFloatingPointEncoded((double)var1_1, this.composer.writer.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeChar(char value) {
        void var1_1;
        this.encodeString(String.valueOf((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeString(String value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.composer.printQuoted((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeEnum(SerialDescriptor enumDescriptor, int index) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.encodeString(var1_1.getElementName((int)var2_2));
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

