/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.OutputStream;
import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.ByteArrayPool;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.StringOpsKt;

@SourceDebugExtension(value={"SMAP\nJvmJsonStreams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmJsonStreams.kt\nkotlinx/serialization/json/internal/JsonToJavaStreamWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n130#1:269\n117#1:271\n130#1:272\n118#1,3:273\n125#1,2:276\n130#1:278\n125#1,2:279\n117#1:281\n130#1:282\n118#1,3:283\n125#1,2:286\n125#1,2:288\n117#1:290\n130#1:291\n118#1,3:292\n125#1,2:295\n125#1,2:297\n125#1,2:299\n117#1:301\n130#1:302\n118#1,3:303\n125#1,2:306\n117#1:308\n130#1:309\n118#1,3:310\n125#1,2:313\n125#1,2:315\n125#1,2:317\n125#1,2:319\n117#1:321\n130#1:322\n118#1,3:323\n125#1,2:326\n117#1:328\n130#1:329\n118#1,3:330\n125#1,2:333\n125#1,2:335\n117#1:337\n130#1:338\n118#1,3:339\n125#1,2:342\n117#1:344\n130#1:345\n118#1,3:346\n125#1,2:349\n125#1,2:351\n125#1,2:353\n117#1:355\n130#1:356\n118#1,3:357\n125#1,2:360\n125#1,2:362\n125#1,2:364\n125#1,2:366\n1#2:270\n*S KotlinDebug\n*F\n+ 1 JvmJsonStreams.kt\nkotlinx/serialization/json/internal/JsonToJavaStreamWriter\n*L\n117#1:269\n148#1:271\n148#1:272\n148#1:273,3\n149#1:276,2\n151#1:278\n158#1:279,2\n165#1:281\n165#1:282\n165#1:283,3\n166#1:286,2\n167#1:288,2\n173#1:290\n173#1:291\n173#1:292,3\n174#1:295,2\n175#1:297,2\n176#1:299,2\n186#1:301\n186#1:302\n186#1:303,3\n187#1:306,2\n196#1:308\n196#1:309\n196#1:310,3\n197#1:313,2\n198#1:315,2\n199#1:317,2\n200#1:319,2\n215#1:321\n215#1:322\n215#1:323,3\n216#1:326,2\n221#1:328\n221#1:329\n221#1:330,3\n222#1:333,2\n223#1:335,2\n228#1:337\n228#1:338\n228#1:339,3\n229#1:342,2\n234#1:344\n234#1:345\n234#1:346,3\n235#1:349,2\n236#1:351,2\n237#1:353,2\n242#1:355\n242#1:356\n242#1:357,3\n243#1:360,2\n244#1:362,2\n245#1:364,2\n246#1:366,2\n*E\n"})
public final class JsonToJavaStreamWriter
implements InternalJsonWriter {
    private final OutputStream stream;
    private final byte[] buffer;
    private char[] charArray;
    private int indexInBuffer;

    /*
     * WARNING - void declaration
     */
    public JsonToJavaStreamWriter(OutputStream stream) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = var1_1;
        this.buffer = ByteArrayPool.INSTANCE.take();
        this.charArray = CharArrayPool.INSTANCE.take();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeLong(long value) {
        void var1_1;
        this.write(String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeChar(char c) {
        void var1_1;
        void var2_4 = var1_1;
        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
        if (var2_4 < 128) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter2;
            JsonToJavaStreamWriter jsonToJavaStreamWriter3 = jsonToJavaStreamWriter2 = jsonToJavaStreamWriter;
            if (jsonToJavaStreamWriter2.buffer.length - jsonToJavaStreamWriter3.indexInBuffer <= 0) {
                jsonToJavaStreamWriter2.flush();
            }
            jsonToJavaStreamWriter2 = jsonToJavaStreamWriter;
            int n = jsonToJavaStreamWriter2.indexInBuffer;
            jsonToJavaStreamWriter2.indexInBuffer = n + 1;
            jsonToJavaStreamWriter2.buffer[n] = (byte)var2_4;
            return;
        }
        if (var2_4 < 2048) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter4;
            JsonToJavaStreamWriter jsonToJavaStreamWriter5 = jsonToJavaStreamWriter4 = jsonToJavaStreamWriter;
            if (jsonToJavaStreamWriter4.buffer.length - jsonToJavaStreamWriter5.indexInBuffer < 2) {
                jsonToJavaStreamWriter4.flush();
            }
            jsonToJavaStreamWriter4 = jsonToJavaStreamWriter;
            int n = var2_4 >> 6 | 0xC0;
            int n2 = jsonToJavaStreamWriter4.indexInBuffer;
            jsonToJavaStreamWriter4.indexInBuffer = n2 + 1;
            jsonToJavaStreamWriter4.buffer[n2] = (byte)n;
            jsonToJavaStreamWriter4 = jsonToJavaStreamWriter;
            n = var2_4 & 0x3F | 0x80;
            n2 = jsonToJavaStreamWriter4.indexInBuffer;
            jsonToJavaStreamWriter4.indexInBuffer = n2 + 1;
            jsonToJavaStreamWriter4.buffer[n2] = (byte)n;
            return;
        }
        boolean bl = 55296 <= var2_4 ? var2_4 < 57344 : false;
        if (bl) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter6;
            JsonToJavaStreamWriter jsonToJavaStreamWriter7 = jsonToJavaStreamWriter6 = jsonToJavaStreamWriter;
            if (jsonToJavaStreamWriter6.buffer.length - jsonToJavaStreamWriter7.indexInBuffer <= 0) {
                jsonToJavaStreamWriter6.flush();
            }
            jsonToJavaStreamWriter6 = jsonToJavaStreamWriter;
            int n = jsonToJavaStreamWriter6.indexInBuffer;
            jsonToJavaStreamWriter6.indexInBuffer = n + 1;
            jsonToJavaStreamWriter6.buffer[n] = 63;
            return;
        }
        if (var2_4 < 65536) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter8;
            JsonToJavaStreamWriter jsonToJavaStreamWriter9 = jsonToJavaStreamWriter8 = jsonToJavaStreamWriter;
            if (jsonToJavaStreamWriter8.buffer.length - jsonToJavaStreamWriter9.indexInBuffer < 3) {
                jsonToJavaStreamWriter8.flush();
            }
            jsonToJavaStreamWriter8 = jsonToJavaStreamWriter;
            int n = var2_4 >> 12 | 0xE0;
            int n3 = jsonToJavaStreamWriter8.indexInBuffer;
            jsonToJavaStreamWriter8.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter8.buffer[n3] = (byte)n;
            jsonToJavaStreamWriter8 = jsonToJavaStreamWriter;
            n = var2_4 >> 6 & 0x3F | 0x80;
            n3 = jsonToJavaStreamWriter8.indexInBuffer;
            jsonToJavaStreamWriter8.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter8.buffer[n3] = (byte)n;
            jsonToJavaStreamWriter8 = jsonToJavaStreamWriter;
            n = var2_4 & 0x3F | 0x80;
            n3 = jsonToJavaStreamWriter8.indexInBuffer;
            jsonToJavaStreamWriter8.indexInBuffer = n3 + 1;
            jsonToJavaStreamWriter8.buffer[n3] = (byte)n;
            return;
        }
        if (var2_4 <= 0x10FFFF) {
            JsonToJavaStreamWriter jsonToJavaStreamWriter10;
            JsonToJavaStreamWriter jsonToJavaStreamWriter11 = jsonToJavaStreamWriter10 = jsonToJavaStreamWriter;
            if (jsonToJavaStreamWriter10.buffer.length - jsonToJavaStreamWriter11.indexInBuffer < 4) {
                jsonToJavaStreamWriter10.flush();
            }
            jsonToJavaStreamWriter10 = jsonToJavaStreamWriter;
            int n = var2_4 >> 18 | 0xF0;
            int n4 = jsonToJavaStreamWriter10.indexInBuffer;
            jsonToJavaStreamWriter10.indexInBuffer = n4 + 1;
            jsonToJavaStreamWriter10.buffer[n4] = (byte)n;
            jsonToJavaStreamWriter10 = jsonToJavaStreamWriter;
            n = var2_4 >> 12 & 0x3F | 0x80;
            n4 = jsonToJavaStreamWriter10.indexInBuffer;
            jsonToJavaStreamWriter10.indexInBuffer = n4 + 1;
            jsonToJavaStreamWriter10.buffer[n4] = (byte)n;
            jsonToJavaStreamWriter10 = jsonToJavaStreamWriter;
            n = var2_4 >> 6 & 0x3F | 0x80;
            n4 = jsonToJavaStreamWriter10.indexInBuffer;
            jsonToJavaStreamWriter10.indexInBuffer = n4 + 1;
            jsonToJavaStreamWriter10.buffer[n4] = (byte)n;
            jsonToJavaStreamWriter10 = jsonToJavaStreamWriter;
            n = var2_4 & 0x3F | 0x80;
            n4 = jsonToJavaStreamWriter10.indexInBuffer;
            jsonToJavaStreamWriter10.indexInBuffer = n4 + 1;
            jsonToJavaStreamWriter10.buffer[n4] = (byte)n;
            return;
        }
        throw new JsonEncodingException("Unexpected code point: " + (int)var2_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(String text) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int length = text.length();
        this.ensureTotalCapacity(0, length);
        char[] cArray = this.charArray;
        var1_1.getChars(0, length, cArray, 0);
        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
        jsonToJavaStreamWriter.writeUtf8(jsonToJavaStreamWriter.charArray, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeQuoted(String text) {
        void var3_4;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ensureTotalCapacity(0, ((String)text).length() + 2);
        char[] arr2 = this.charArray;
        this.charArray[0] = 34;
        int length2 = ((String)text).length();
        String string = text;
        string.getChars(0, length2, arr2, 1);
        int n = 1 + length2;
        for (int i = 1; i < n; ++i) {
            char ch = arr2[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            String length2 = text;
            int arr2 = i;
            text = this;
            i = arr2--;
            n = length2.length();
            while (arr2 < n) {
                byte by;
                i = super.ensureTotalCapacity(i, 2);
                char c = length2.charAt(arr2);
                if (c < StringOpsKt.getESCAPE_MARKERS().length && (by = StringOpsKt.getESCAPE_MARKERS()[c]) != 0) {
                    if (by == 1) {
                        String string2;
                        Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[c]);
                        i = super.ensureTotalCapacity(i, string2.length());
                        String string3 = string2;
                        char[] cArray = ((JsonToJavaStreamWriter)text).charArray;
                        int n2 = string2.length();
                        string3.getChars(0, n2, cArray, i);
                        i += string2.length();
                    } else {
                        ((JsonToJavaStreamWriter)text).charArray[i] = 92;
                        ((JsonToJavaStreamWriter)text).charArray[i + 1] = (char)by;
                        i += 2;
                    }
                } else {
                    ((JsonToJavaStreamWriter)text).charArray[i++] = c;
                }
                ++arr2;
            }
            super.ensureTotalCapacity(i, 1);
            ((JsonToJavaStreamWriter)text).charArray[i++] = 34;
            Object object = text;
            super.writeUtf8(((JsonToJavaStreamWriter)object).charArray, i);
            super.flush();
            return;
        }
        arr2[length2 + 1] = 34;
        this.writeUtf8((char[])var2_2, (int)(var3_4 + 2));
        this.flush();
    }

    /*
     * WARNING - void declaration
     */
    private final int ensureTotalCapacity(int oldSize, int additional) {
        void var1_1;
        int newSize = oldSize + additional;
        if (this.charArray.length <= newSize) {
            void var2_2;
            char[] cArray = Arrays.copyOf(this.charArray, RangesKt.coerceAtLeast((int)var2_2, (int)(oldSize * 2)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(...)");
            this.charArray = cArray;
        }
        return (int)var1_1;
    }

    public final void release() {
        this.flush();
        CharArrayPool.INSTANCE.release(this.charArray);
        ByteArrayPool.INSTANCE.release(this.buffer);
    }

    private final void flush() {
        this.stream.write(this.buffer, 0, this.indexInBuffer);
        this.indexInBuffer = 0;
    }

    private final void writeUtf8(char[] string, int count) {
        if (!(count >= 0)) {
            String string2 = "count < 0";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(count <= string.length)) {
            String string3 = "count > string.length: " + count + " > " + string.length;
            throw new IllegalArgumentException(string3.toString());
        }
        int i = 0;
        while (i < count) {
            JsonToJavaStreamWriter this_$iv;
            int this_$iv$iv42;
            char low;
            block17: {
                JsonToJavaStreamWriter this_$iv2;
                block16: {
                    JsonToJavaStreamWriter this_$iv$iv2;
                    char c = string[i];
                    if (c < '\u0080') {
                        JsonToJavaStreamWriter this_$iv3;
                        this_$iv$iv2 = this_$iv3 = this;
                        if (this_$iv3.buffer.length - this_$iv$iv2.indexInBuffer <= 0) {
                            this_$iv3.flush();
                        }
                        this_$iv3 = this;
                        int n = this_$iv3.indexInBuffer;
                        this_$iv3.indexInBuffer = n + 1;
                        this_$iv3.buffer[n] = (byte)c;
                        JsonToJavaStreamWriter this_$iv222 = this;
                        int this_$iv222 = ++i + (this_$iv222.buffer.length - this_$iv222.indexInBuffer);
                        int runLimit = Math.min(count, this_$iv222);
                        while (i < runLimit && (c = string[i]) < '\u0080') {
                            JsonToJavaStreamWriter this_$iv4 = this;
                            int this_$iv$iv2 = this_$iv4.indexInBuffer;
                            this_$iv4.indexInBuffer = this_$iv$iv2 + 1;
                            this_$iv4.buffer[this_$iv$iv2] = (byte)c;
                            ++i;
                        }
                        continue;
                    }
                    if (c < '\u0800') {
                        JsonToJavaStreamWriter this_$iv5;
                        this_$iv$iv2 = this_$iv5 = this;
                        if (this_$iv5.buffer.length - this_$iv$iv2.indexInBuffer < 2) {
                            this_$iv5.flush();
                        }
                        this_$iv5 = this;
                        int byte$iv = c >> 6 | 0xC0;
                        int this_$iv$iv2 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv2 + 1;
                        this_$iv5.buffer[this_$iv$iv2] = (byte)byte$iv;
                        this_$iv5 = this;
                        byte$iv = c & 0x3F | 0x80;
                        this_$iv$iv2 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv2 + 1;
                        this_$iv5.buffer[this_$iv$iv2] = (byte)byte$iv;
                        ++i;
                        continue;
                    }
                    if (c < '\ud800' || c > '\udfff') {
                        JsonToJavaStreamWriter this_$iv6;
                        this_$iv$iv2 = this_$iv6 = this;
                        if (this_$iv6.buffer.length - this_$iv$iv2.indexInBuffer < 3) {
                            this_$iv6.flush();
                        }
                        this_$iv6 = this;
                        int byte$iv = c >> 12 | 0xE0;
                        int this_$iv$iv3 = this_$iv6.indexInBuffer;
                        this_$iv6.indexInBuffer = this_$iv$iv3 + 1;
                        this_$iv6.buffer[this_$iv$iv3] = (byte)byte$iv;
                        this_$iv6 = this;
                        byte$iv = c >> 6 & 0x3F | 0x80;
                        this_$iv$iv3 = this_$iv6.indexInBuffer;
                        this_$iv6.indexInBuffer = this_$iv$iv3 + 1;
                        this_$iv6.buffer[this_$iv$iv3] = (byte)byte$iv;
                        this_$iv6 = this;
                        byte$iv = c & 0x3F | 0x80;
                        this_$iv$iv3 = this_$iv6.indexInBuffer;
                        this_$iv6.indexInBuffer = this_$iv$iv3 + 1;
                        this_$iv6.buffer[this_$iv$iv3] = (byte)byte$iv;
                        ++i;
                        continue;
                    }
                    char c2 = low = i + 1 < count ? string[i + 1] : (char)'\u0000';
                    if (c > '\udbff') break block16;
                    if ('\udc00' <= low ? low < '\ue000' : false) break block17;
                }
                JsonToJavaStreamWriter this_$iv$iv42 = this_$iv2 = this;
                if (this_$iv2.buffer.length - this_$iv$iv42.indexInBuffer <= 0) {
                    this_$iv2.flush();
                }
                this_$iv2 = this;
                this_$iv$iv42 = this_$iv2.indexInBuffer;
                this_$iv2.indexInBuffer = this_$iv$iv42 + 1;
                this_$iv2.buffer[this_$iv$iv42] = 63;
                ++i;
                continue;
            }
            int codePoint = 65536 + ((this_$iv$iv42 & 0x3FF) << 10 | low & 0x3FF);
            JsonToJavaStreamWriter this_$iv$iv = this_$iv = this;
            if (this_$iv.buffer.length - this_$iv$iv.indexInBuffer < 4) {
                this_$iv.flush();
            }
            this_$iv = this;
            int byte$iv = codePoint >> 18 | 0xF0;
            int n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint >> 12 & 0x3F | 0x80;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint >> 6 & 0x3F | 0x80;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint & 0x3F | 0x80;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            i += 2;
        }
    }
}

