/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.ReaderJsonLexer;
import kotlinx.serialization.json.internal.StreamingJsonDecoder;
import kotlinx.serialization.json.internal.WriteMode;

final class JsonIteratorArrayWrapped<T>
implements Iterator<T>,
KMappedMarker {
    private final Json json;
    private final ReaderJsonLexer lexer;
    private final DeserializationStrategy<T> deserializer;
    private boolean first;
    private boolean finished;

    /*
     * WARNING - void declaration
     */
    public JsonIteratorArrayWrapped(Json json, ReaderJsonLexer lexer, DeserializationStrategy<? extends T> deserializer) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        this.json = var1_1;
        this.lexer = var2_2;
        this.deserializer = var3_3;
        this.first = true;
    }

    @Override
    public final T next() {
        if (this.first) {
            this.first = false;
        } else {
            ((AbstractJsonLexer)this.lexer).consumeNextToken(',');
        }
        StreamingJsonDecoder streamingJsonDecoder = new StreamingJsonDecoder(this.json, WriteMode.OBJ, this.lexer, this.deserializer.getDescriptor(), null);
        return (T)streamingJsonDecoder.decodeSerializableValue(this.deserializer);
    }

    @Override
    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.lexer.peekNextToken() == 9) {
            this.finished = true;
            this.lexer.consumeNextToken((byte)9);
            if (this.lexer.isNotEof()) {
                if (this.lexer.peekNextToken() == 8) {
                    AbstractJsonLexer.fail$default(this.lexer, "There is a start of the new array after the one parsed to sequence. ARRAY_WRAPPED mode doesn't merge consecutive arrays.\nIf you need to parse a stream of arrays, please use WHITESPACE_SEPARATED mode instead.", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                this.lexer.expectEof();
            }
            return false;
        }
        if (!this.lexer.isNotEof() && !this.finished) {
            AbstractJsonLexer.fail$kotlinx_serialization_json$default(this.lexer, (byte)9, false, 2, null);
            throw new KotlinNothingValueException();
        }
        return true;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

