/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.InlineClassDescriptorKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.StringJsonLexer;
import kotlinx.serialization.json.internal.StringOpsKt;

@SourceDebugExtension(value={"SMAP\nJsonElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonElement.kt\nkotlinx/serialization/json/JsonElementKt\n*L\n1#1,348:1\n338#1,4:349\n330#1,4:353\n338#1,4:357\n330#1,4:361\n*S KotlinDebug\n*F\n+ 1 JsonElement.kt\nkotlinx/serialization/json/JsonElementKt\n*L\n259#1:349,4\n269#1:353,4\n278#1:357,4\n285#1:361,4\n*E\n"})
public final class JsonElementKt {
    private static final SerialDescriptor jsonUnquotedLiteralDescriptor = InlineClassDescriptorKt.InlinePrimitiveDescriptor((String)"kotlinx.serialization.json.JsonUnquotedLiteral", (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE));

    public static final JsonPrimitive JsonPrimitive(String value) {
        String string;
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(string, true, null, 4, null);
    }

    public static final SerialDescriptor getJsonUnquotedLiteralDescriptor() {
        return jsonUnquotedLiteralDescriptor;
    }

    public static final JsonPrimitive getJsonPrimitive(JsonElement $this$jsonPrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonPrimitive, (String)"<this>");
        JsonPrimitive jsonPrimitive = $this$jsonPrimitive instanceof JsonPrimitive ? (JsonPrimitive)$this$jsonPrimitive : null;
        if (jsonPrimitive == null) {
            JsonElement jsonElement;
            JsonElementKt.error(jsonElement, "JsonPrimitive");
            throw new KotlinNothingValueException();
        }
        return jsonPrimitive;
    }

    public static final JsonObject getJsonObject(JsonElement $this$jsonObject) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonObject, (String)"<this>");
        JsonObject jsonObject = $this$jsonObject instanceof JsonObject ? (JsonObject)$this$jsonObject : null;
        if (jsonObject == null) {
            JsonElement jsonElement;
            JsonElementKt.error(jsonElement, "JsonObject");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getInt(JsonPrimitive $this$int) {
        void var1_3;
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$int, (String)"<this>");
        try {
            l = new StringJsonLexer($this$int.getContent()).consumeNumericLiteral();
        }
        catch (JsonDecodingException e$iv) {
            void var0_1;
            throw new NumberFormatException(var0_1.getMessage());
        }
        long result = l;
        if (!(Integer.MIN_VALUE <= result ? result <= Integer.MAX_VALUE : false)) {
            JsonPrimitive jsonPrimitive;
            throw new NumberFormatException(jsonPrimitive.getContent() + " is not an Int");
        }
        return (int)var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public static final long getLong(JsonPrimitive $this$long) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$long, (String)"<this>");
        try {
            l = new StringJsonLexer($this$long.getContent()).consumeNumericLiteral();
        }
        catch (JsonDecodingException e$iv) {
            void var0_1;
            throw new NumberFormatException(var0_1.getMessage());
        }
        return l;
    }

    public static final double getDouble(JsonPrimitive $this$double) {
        JsonPrimitive jsonPrimitive;
        Intrinsics.checkNotNullParameter((Object)$this$double, (String)"<this>");
        return Double.parseDouble(jsonPrimitive.getContent());
    }

    public static final float getFloat(JsonPrimitive $this$float) {
        JsonPrimitive jsonPrimitive;
        Intrinsics.checkNotNullParameter((Object)$this$float, (String)"<this>");
        return Float.parseFloat(jsonPrimitive.getContent());
    }

    public static final Boolean getBooleanOrNull(JsonPrimitive $this$booleanOrNull) {
        JsonPrimitive jsonPrimitive;
        Intrinsics.checkNotNullParameter((Object)$this$booleanOrNull, (String)"<this>");
        return StringOpsKt.toBooleanStrictOrNull(jsonPrimitive.getContent());
    }

    public static final String getContentOrNull(JsonPrimitive $this$contentOrNull) {
        JsonPrimitive jsonPrimitive;
        Intrinsics.checkNotNullParameter((Object)$this$contentOrNull, (String)"<this>");
        if ($this$contentOrNull instanceof JsonNull) {
            return null;
        }
        return jsonPrimitive.getContent();
    }

    /*
     * WARNING - void declaration
     */
    private static final Void error(JsonElement $this$error, String element) {
        void var1_1;
        JsonElement jsonElement;
        throw new IllegalArgumentException("Element " + Reflection.getOrCreateKotlinClass(jsonElement.getClass()) + " is not a " + (String)var1_1);
    }
}

